
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Generate new data for the media domain
# Sample data for the line plot
x = np.array([0, 2, 4, 6, 8, 10])  # representing years
y = np.array([50, 55, 65, 70, 62, 75])  # audience engagement scores
error = np.array([5, 4, 6, 5, 7, 6])

# Sample data for the box plot
data = [np.random.normal(60, 10, 100) for _ in range(5)]
positions = [0, 2, 4, 6, 8]
# Scatter data points
scatters_data = np.random.normal(70, 5, len(positions))

titles = ["(a) Audience Engagement Over Years", "(b) Engagement Distribution by Period"]
xlabels = ["Years", "Periods"]
ylabels = ["Engagement Score", "Engagement Score"]
xtickslabels = [
    ["0", "2", "4", "6", "8", "10"],
    ["0", "2", "4", "6", "8"],
]
yticks = [np.arange(40, 81, 10), np.arange(30, 101, 20)]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, axs = plt.subplots(2, 1, figsize=(5, 6))

# Line plot
axs[0].errorbar(
    x,
    y,
    yerr=error,
    fmt="o-",
    ecolor="lightblue",
    markersize=8,
    linewidth=1,
    color="darkblue",
    linestyle='--',
    marker='s'
)
axs[0].fill_between(x, y - error, y + error, color="lightblue", alpha=0.5)
axs[0].set_title(titles[0])
axs[0].set_xlabel(xlabels[0])
axs[0].set_ylabel(ylabels[0])
axs[0].grid(True)
axs[0].set_xticks(x)
axs[0].set_xticklabels(xtickslabels[0])
axs[0].set_yticks(yticks[0])

# Box plot
# set all linewidth to 1
axs[1].boxplot(
    data,
    positions=positions,
    widths=0.8,
    showfliers=False,
    boxprops=dict(color="darkgreen", linewidth=2),
    medianprops=dict(color="darkgreen", linewidth=2),
    whiskerprops=dict(color="darkgreen", linewidth=2),
    capprops=dict(color="darkgreen", linewidth=2),
)
axs[1].set_title(titles[1])
axs[1].set_xlabel(xlabels[1])
axs[1].set_ylabel(ylabels[1])
axs[1].yaxis.grid(True)
axs[1].set_xticks(positions)
axs[1].set_xticklabels(xtickslabels[1])
axs[1].set_yticks(yticks[1])

axs[1].scatter(positions, scatters_data, marker="^", color="darkgrey", s=100, zorder=3)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()

plt.savefig("multidiff_67.pdf", bbox_inches="tight")
