
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for bar plot
categories = ["Cars", "Trucks", "Motorcycles"]
values = [25, 15, 55]

# Data for heatmap
data = np.array(
    [[0.8, -0.4, 0.6, 0.3], [-0.3, 0.7, -0.5, 0.4], [0.5, 0.2, -0.6, 0.7]]
)
rows = ["Cars", "Trucks", "Motorcycles"]
columns = ["Fuel Efficiency", "Maintenance Cost", "Emission Rate", "Safety Score"]
ylabel = "Average Fuel Efficiency (MPG)"
ylim = [0, 60]
suptitle = "Vehicle Performance Consistency and Correlation Analysis"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the bar plot on the left
plt.figure(figsize=(12, 5))

plt.subplot(1, 2, 1)
bars = plt.bar(categories, values, color=["#4C72B0", "#55A868", "#C44E52"])
plt.ylabel(ylabel, fontsize=12)
plt.ylim(ylim)
for bar, value in zip(bars, values):
    plt.text(bar.get_x() + bar.get_width() / 2, bar.get_height() - 2, f"{value:.0f}", 
             ha='center', va='center', color='white', fontsize=10, fontweight='bold')

# Create the heatmap on the right
plt.subplot(1, 2, 2)
heatmap = plt.imshow(data, cmap="coolwarm", interpolation="nearest", vmin=-1.0, vmax=1.0)
plt.xticks(np.arange(len(columns)), columns, rotation=30, ha="right", fontsize=10)
plt.yticks(np.arange(len(rows)), rows, fontsize=10)
plt.colorbar(heatmap)

# Annotate the heatmap with text
for i in range(len(rows)):
    for j in range(len(columns)):
        plt.text(j, i, f"{data[i, j]:.2f}", ha="center", va="center", color="black", fontsize=10)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent overlap
plt.suptitle(suptitle, fontsize=14, fontweight='bold')
plt.tight_layout(rect=[0, 0, 1, 0.95])

plt.savefig("multidiff_70.pdf", bbox_inches="tight")
