

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for bar chart
weather_types = ["Sunny", "Rainy", "Cloudy", "Snowy"]
successful_forecast_days = [30, 15, 25, 10]

# Data for boxplot
temperature_data = [np.random.normal(20, 5, 100) for _ in weather_types]

temperature_threshold_upper = 30
temperature_threshold_lower = 10
ylabels = ["# Successful\nForecast Days", "Temperature (°C)"]
ax2hlineslabels = ["Upper Temperature Threshold", "Lower Temperature Threshold"]
ax2ylim = [0.0, 40.0]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Colors
bar_color = "#6495ED"
boxplot_facecolor = "#87CEFA"
boxplot_edgecolor = "black"
bar_edgecolor = "black"
median_color = "black"
upper_threshold_color = "green"
lower_threshold_color = "red"
fill_color = "grey"

# Create figure and subplots; ax1 and ax2 share the same x-axis
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(8, 8), sharex=True)

# Bar chart
ax1.bar(
    weather_types,
    successful_forecast_days,
    hatch="\\",
    color=bar_color,
    edgecolor=bar_edgecolor,
    width=0.6,
)
ax1.set_ylabel(ylabels[0])

# Boxplot chart
ax2.boxplot(temperature_data, positions=range(len(weather_types)), widths=0.6, patch_artist=True,
            boxprops=dict(facecolor=boxplot_facecolor, color=boxplot_edgecolor),
            medianprops=dict(color=median_color, linewidth=1.5))
ax2.hlines(
    temperature_threshold_upper,
    xmin=-0.5,
    xmax=len(weather_types) - 0.5,
    colors=upper_threshold_color,
    linestyles="dashed",
    label=ax2hlineslabels[0],
)
ax2.hlines(
    temperature_threshold_lower,
    xmin=-0.5,
    xmax=len(weather_types) - 0.5,
    colors=lower_threshold_color,
    linestyles="dashed",
    label=ax2hlineslabels[1],
)
ax2.fill_between(
    [-0.5, len(weather_types) - 0.5],
    temperature_threshold_lower,
    temperature_threshold_upper,
    color=fill_color,
    alpha=0.15,
)
ax2.set_ylabel(ylabels[1])
ax2.yaxis.set_major_formatter(plt.FuncFormatter(lambda x, _: f"{x:.2f}"))
ax2.set_ylim(ax2ylim)
ax2.set_xticklabels(weather_types)
ax2.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("multidiff_73.pdf", bbox_inches="tight")
