
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for Area Chart - Represents percentage increases in media content consumption by age group
age_groups = ["<18", "18-24", "25-34", "35-44", "45-54", "55+"]
video_streaming = np.array([10, 20, 35, 30, 25, 15])
social_media = np.array([15, 25, 30, 20, 15, 10])
news_sites = np.array([5, 10, 20, 25, 30, 25])

# Cumulative data for the stacked area chart
cumulative_video_streaming = video_streaming
cumulative_social_media = cumulative_video_streaming + social_media
cumulative_news_sites = cumulative_social_media + news_sites

# Data for Bar Chart - Shows the number of media platforms by type
media_types = [
    "Video Streaming",
    "Social Media",
    "News Sites",
    "Blogs",
    "Podcasts",
    "Radio",
    "Television",
]
platforms = [50, 80, 40, 30, 20, 25, 35]
titles = [
    "Content Consumption by Age Group",
    "Number of Platforms by Media Type",
]
xlabels = ["Age Group", "Media Type"]
ylabels = ["Cumulative Consumption (%)", "Number of Platforms"]
ax1labels = ["Video Streaming", "Social Media", "News Sites"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Creating the subplot layout
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))

# Plotting the Area Chart
color_video_streaming = "#1f77b4"
color_social_media = "#ff7f0e"
color_news_sites = "#2ca02c"
color_bar_chart = "#d62728"

ax1.fill_between(
    age_groups, 0, cumulative_video_streaming, label=ax1labels[0], color=color_video_streaming, alpha=0.6
)
ax1.fill_between(
    age_groups,
    cumulative_video_streaming,
    cumulative_social_media,
    label=ax1labels[1],
    color=color_social_media,
    alpha=0.6,
)
ax1.fill_between(
    age_groups,
    cumulative_social_media,
    cumulative_news_sites,
    label=ax1labels[2],
    color=color_news_sites,
    alpha=0.6,
)
ax1.set_title(titles[0])
ax1.set_xlabel(xlabels[0])
ax1.set_ylabel(ylabels[0])
ax1.legend(loc="upper left")

# Plotting the Bar Chart
ax2.bar(media_types, platforms, color=color_bar_chart)
ax2.set_title(titles[1])
ax2.set_xlabel(xlabels[1])
ax2.set_ylabel(ylabels[1])
ax2.set_xticklabels(media_types, rotation=45)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout and saving the figure
plt.tight_layout()
plt.savefig("multidiff_75.pdf", bbox_inches="tight")
