
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for Area Chart - Represents sales over quarters by product category
quarters = ["Q1", "Q2", "Q3", "Q4"]
electronics = np.array([300, 350, 400, 450])
fashion = np.array([200, 250, 300, 350])
groceries = np.array([150, 200, 250, 300])
furniture = np.array([100, 150, 200, 250])

# Cumulative data for the stacked Area chart
cumulative_electronics = electronics
cumulative_fashion = cumulative_electronics + fashion
cumulative_groceries = cumulative_fashion + groceries
cumulative_furniture = cumulative_groceries + furniture

# Data for Bar Chart - Shows revenue distribution by region
regions = ["North", "South", "East", "West", "Central"]
revenue_distribution = [1200, 1500, 1300, 1700, 1400]
titles = ["Quarterly Sales by Product Category", "Revenue Distribution by Region"]
xlabels = ["Quarter", "Region"]
ylabels = ["Cumulative Sales (in $1000s)", "Revenue (in $1000s)"]
ax1labels = ["Electronics", "Fashion", "Groceries", "Furniture"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Creating the subplot layout
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))

# Plotting the Area Chart
ax1.fill_between(
    quarters, 0, cumulative_electronics, label=ax1labels[0], color="#1f77b4", alpha=0.7
)
ax1.fill_between(
    quarters,
    cumulative_electronics,
    cumulative_fashion,
    label=ax1labels[1],
    color="#ff7f0e",
    alpha=0.7,
)
ax1.fill_between(
    quarters,
    cumulative_fashion,
    cumulative_groceries,
    label=ax1labels[2],
    color="#2ca02c",
    alpha=0.7,
)
ax1.fill_between(
    quarters,
    cumulative_groceries,
    cumulative_furniture,
    label=ax1labels[3],
    color="#d62728",
    alpha=0.7,
)
ax1.set_title(titles[0])
ax1.set_xlabel(xlabels[0])
ax1.set_ylabel(ylabels[0])
ax1.legend(loc="upper left")

# Plotting the Bar Chart
ax2.bar(regions, revenue_distribution, color="#9467bd")
ax2.set_title(titles[1])
ax2.set_xlabel(xlabels[1])
ax2.set_ylabel(ylabels[1])
ax2.set_xticklabels(regions, rotation=45)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout and saving the figure
plt.tight_layout()
plt.savefig("multidiff_76.pdf", bbox_inches="tight")

