
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)

# Data for Area Chart
years = ["2015", "2016", "2017", "2018", "2019", "2020", "2021", "2022"]
vehicle_registrations = np.array([200, 220, 250, 280, 300, 350, 380, 400])
public_transport_usage = np.array([150, 140, 130, 120, 110, 100, 90, 85])
electric_vehicle_adoption = np.array([10, 15, 25, 35, 50, 70, 90, 120])

# Data for Box Plot
data_urban = np.random.normal(400, 50, 100)
data_suburban = np.random.normal(300, 60, 100)
data_rural = np.random.normal(200, 70, 100)
data_coastal = np.random.normal(250, 65, 100)
data = [data_urban, data_suburban, data_rural, data_coastal]

# Labels and Titles
area_labels = ["Vehicle Registrations", "Public Transport Usage", "Electric Vehicle Adoption"]
chart_titles = [
    "Transportation Trends Over Years",
    "Vehicle Registrations Across Regions",
]
x_axis_label = ["Year"]
region_labels = ["Urban", "Suburban", "Rural", "Coastal"]
y_axis_labels = ["Number of Vehicles", "Vehicle Registrations"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with two subplots in a vertical layout
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(10, 12))

# ----- Area Chart for Transportation Trends -----
# Calculate cumulative values for stacked area chart
cumulative_vehicle_registrations = vehicle_registrations
cumulative_public_transport_usage = cumulative_vehicle_registrations + public_transport_usage
cumulative_electric_vehicle_adoption = cumulative_public_transport_usage + electric_vehicle_adoption

# Plotting Area Chart
ax1.fill_between(
    years, 0, cumulative_vehicle_registrations, label=area_labels[0], color="#4CAF50", alpha=0.7
)
ax1.fill_between(
    years,
    cumulative_vehicle_registrations,
    cumulative_public_transport_usage,
    label=area_labels[1],
    color="#8B4513",
    alpha=0.7,
)
ax1.fill_between(
    years,
    cumulative_public_transport_usage,
    cumulative_electric_vehicle_adoption,
    label=area_labels[2],
    color="#1E90FF",
    alpha=0.7,
)

ax1.set_title(chart_titles[0])
ax1.set_xlabel(x_axis_label[0])
ax1.set_ylabel(y_axis_labels[0])
ax1.legend(loc="upper left")
ax1.grid(True)

# ----- Box Plot for Vehicle Registrations -----
# Creating Box Plot
bp = ax2.boxplot(data, patch_artist=True, notch=False, showfliers=False)

# Customizing boxplot colors
colors = ["#4CAF50", "#8B4513", "#1E90FF", "#FFD700"]
for patch, color in zip(bp["boxes"], colors):
    patch.set_facecolor(color)
for median in bp["medians"]:
    median.set(color="black")

# Setting labels and titles
ax2.set_xticklabels(region_labels)
ax2.set_ylabel(y_axis_labels[1])
ax2.set_title(chart_titles[1])
ax2.yaxis.grid(True)
ax2.spines["top"].set_visible(False)
ax2.spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("multidiff_78.pdf", bbox_inches="tight")
