
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for Area Chart
years = ["2000", "2005", "2010", "2015", "2020", "2025"]
urban_population = np.array([50, 55, 60, 70, 80, 90])
suburban_population = np.array([30, 35, 40, 45, 50, 55])
rural_population = np.array([20, 18, 16, 14, 12, 10])

# Data for Box Plot
data_america = np.random.normal(100, 20, 100)
data_europe = np.random.normal(80, 18, 100)
data_asia = np.random.normal(150, 30, 100)
data_africa = np.random.normal(60, 25, 100)
box_data = [data_america, data_europe, data_asia, data_africa]

# Text and Label Parameters
area_labels = ["Urban", "Suburban", "Rural"]
plot_titles = [
    "Growth of Population Groups",
    "Population Spread by Continent",
]
xlabels = ["Year"]
box_xtick_labels = ["America", "Europe", "Asia", "Africa"]
ylabels = ["Population (Millions)", "Population Spread (Millions)"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with two subplots in a vertical layout
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(10, 12))

# ----- Area Chart for Population Growth -----
# Calculate cumulative values for stacked area chart
cumulative_urban = urban_population
cumulative_suburban = cumulative_urban + suburban_population
cumulative_rural = cumulative_suburban + rural_population

# Plotting Area Chart
ax1.fill_between(
    years, 0, cumulative_urban, label=area_labels[0], color="#8c564b", alpha=0.7
)
ax1.fill_between(
    years,
    cumulative_urban,
    cumulative_suburban,
    label=area_labels[1],
    color="#e377c2",
    alpha=0.7,
)
ax1.fill_between(
    years,
    cumulative_suburban,
    cumulative_rural,
    label=area_labels[2],
    color="#7f7f7f",
    alpha=0.7,
)

ax1.set_title(plot_titles[0])
ax1.set_xlabel(xlabels[0])
ax1.set_ylabel(ylabels[0])
ax1.legend(loc="upper left")
ax1.grid(True)

# ----- Box Plot for Population Spread -----
# Creating Box Plot
bp = ax2.boxplot(box_data, patch_artist=True, notch=False, showfliers=False)

# Customizing boxplot colors
box_colors = ["#bcbd22", "#17becf", "#9edae5", "#ff9896"]
for patch, color in zip(bp["boxes"], box_colors):
    patch.set_facecolor(color)
for median in bp["medians"]:
    median.set(color="black")

# Setting labels and titles
ax2.set_xticklabels(box_xtick_labels)
ax2.set_ylabel(ylabels[1])
ax2.set_title(plot_titles[1])
ax2.yaxis.grid(True)
ax2.spines["top"].set_visible(False)
ax2.spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("multidiff_79.pdf", bbox_inches="tight")

