
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# ErrorBar Plot Data for "Average Daily Screen Time by Device Type"
# Devices
devices = ["Smartphone", "Tablet", "Laptop", "Desktop", "TV"]
# Hypothetical average daily screen time (in hours)
screen_times = [3.5, 2.1, 4, 3, 2.8]
# Standard errors for the above screen times
screen_time_errors = [0.3, 0.2, 0.5, 0.4, 0.3]

# ErrorPoint Plot Data for "Percentage of People Using Streaming Services"
# Types of streaming services
services = ["Netflix", "Amazon Prime", "Disney+", "Hulu", "HBO Max"]
# Randomly generated means and standard deviations for percentages
service_percentages = np.random.uniform(40, 90, len(services))
service_std_devs = np.random.uniform(3, 7, len(services))
mean_service_percentage = np.mean(service_percentages)

# Titles and Labels
titles = ["Average Daily Screen Time by Device Type", "Percentage of People Using Streaming Services"]
ylabels = ["Screen Time (hours)", "Percentage (%)"]
ylim = [0, 100]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes for the subplots
fig, axes = plt.subplots(2, 1, figsize=(8, 10))

# Colors
bar_color = "#2a9d8f"
error_color = "grey"
point_color = "#264653"
highlight_line_color = "grey"

# ErrorBar Plot
axes[0].bar(
    devices, screen_times, yerr=screen_time_errors, color=bar_color, capsize=5, ecolor=error_color
)
axes[0].set_title(titles[0])
axes[0].set_ylabel(ylabels[0])
axes[0].grid(True)

# ErrorPoint Plot
axes[1].errorbar(
    services,
    service_percentages,
    yerr=service_std_devs,
    fmt="o",
    color=point_color,
    ecolor=point_color,
    capsize=5,
    ms=8,
)
axes[1].axhline(y=mean_service_percentage, color=highlight_line_color, linestyle="--")
axes[1].set_title(titles[1])
axes[1].set_ylabel(ylabels[1])
axes[1].set_ylim(ylim)
axes[1].grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to avoid overlap and save the figure
plt.tight_layout()
plt.savefig("multidiff_82.pdf", bbox_inches="tight")
