
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Redefined data for Area Chart - Cumulative Pollutant Emissions Over Decades
decades = ["1980s", "1990s", "2000s", "2010s"]
SO2_emissions = np.array([200, 180, 160, 140])
NOx_emissions = np.array([150, 140, 130, 120])
CO_emissions = np.array([100, 95, 90, 85])

# Adjust the cumulative calculation for clarity in visualization
cumulative_SO2 = SO2_emissions
cumulative_NOx = cumulative_SO2 + NOx_emissions
cumulative_CO = cumulative_NOx + CO_emissions

# New data for Bar Chart - Average CO2 Emissions Per Capita by Country
countries = ["USA", "China", "India", "Germany", "UK", "Australia"]
CO2_emissions_per_capita = [16.5, 8.0, 1.9, 9.7, 5.8, 16.2]

# Redefined data for Histogram - Distribution of Daily Air Quality Index (AQI) Readings
urban_AQI = np.random.normal(120, 30, 1000)
rural_AQI = np.random.normal(80, 20, 1000)
bins = np.linspace(0, 300, 30)  # Uniform bin size for both histograms

ax1labels = ["SO2", "NOx", "CO"]
titles = [
    "Cumulative Pollutant Emissions Over Decades",
    "Average CO2 Emissions Per Capita by Country",
    "Distribution of Daily AQI Readings",
]
xlabels = ["Decade", "Country", "AQI"]
ylabels = ["Total Emissions (in tons)", "CO2 Emissions (in tons per capita)", "Frequency"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure with subplots
fig, (ax1, ax2, ax3) = plt.subplots(1, 3, figsize=(15, 5))

# Plotting the Area Chart with new data
ax1.stackplot(
    decades,
    cumulative_SO2,
    cumulative_NOx,
    cumulative_CO,
    labels=ax1labels,
    colors=["#ff9999", "#66b3ff", "#99ff99"],
    alpha=0.8,
)
ax1.set_title(titles[0])
ax1.set_xlabel(xlabels[0])
ax1.set_ylabel(ylabels[0])
ax1.legend(loc="upper right")

# Plotting the Bar Chart with different data
ax2.bar(countries, CO2_emissions_per_capita, color="#c2a5cf")
ax2.set_title(titles[1])
ax2.set_xlabel(xlabels[1])
ax2.set_ylabel(ylabels[1])
ax2.set_xticklabels(countries, rotation=45)

# Plotting two overlapping Histograms
ax3.hist(urban_AQI, bins=bins, color="#8dd3c7", alpha=0.7, label="Urban AQI")
ax3.hist(rural_AQI, bins=bins, color="#fb8072", alpha=0.7, label="Rural AQI")
ax3.set_title(titles[2])
ax3.set_xlabel(xlabels[2])
ax3.set_ylabel(ylabels[2])
ax3.legend()

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot as a PDF file
plt.tight_layout()
plt.savefig("multidiff_88.pdf", bbox_inches="tight")
