
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.gridspec import GridSpec

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# ========== Bar with Error Data (Average Movie Ratings by Genre) ==========
# Movie Genres
movie_genres = ["Action", "Drama", "Comedy", "Horror"]
# Average ratings
avg_ratings = [7.8, 8.2, 7.5, 6.9]
# Error margins
rating_errors = [0.2, 0.3, 0.4, 0.5]

# ========== Scatter with Error Data (Video Game Popularity Scores) ==========
# Video Game Titles
video_games = ["Game A", "Game B", "Game C", "Game D"]
# Popularity scores
popularity_scores = np.random.uniform(70, 95, len(video_games))
# Standard deviations
popularity_std_devs = np.random.uniform(2, 5, len(video_games))

# ========== Line with Error Data (TV Show Viewer Ratings) ==========
# TV Show Seasons
seasons = ["Season 1", "Season 2", "Season 3", "Season 4"]
# Viewer ratings
ratings_classic = np.random.uniform(85, 95, len(seasons))
ratings_recent = np.random.uniform(75, 90, len(seasons))
# Error
rating_errors = np.random.uniform(1, 3, len(seasons))

# Titles and Labels
titles = [
    "Average Movie Ratings by Genre",
    "Video Game Popularity Scores",
    "TV Show Viewer Ratings per Season",
]
ylabels = ["Average Rating", "Popularity Score", "Viewer Rating"]
ax2ylim = [65, 100]
ax3labels = ["Classic Seasons", "Recent Seasons"]

legend_title = "Seasons"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and grid layout
fig = plt.figure(figsize=(10, 10))
gs = GridSpec(2, 2, figure=fig)

# Bar with Error Plot
ax1 = fig.add_subplot(gs[0, :])
ax1.bar(movie_genres, avg_ratings, yerr=rating_errors, color="#d4a373", capsize=5, ecolor="darkred")
ax1.set_title(titles[0])
ax1.set_ylabel(ylabels[0])
ax1.grid(True)

# Scatter with Error Plot
ax2 = fig.add_subplot(gs[1, 0])
ax2.errorbar(
    video_games,
    popularity_scores,
    yerr=popularity_std_devs,
    fmt="o",
    color="#81b29a",
    ecolor="darkred",
    capsize=5,
    ms=10,
)
ax2.set_title(titles[1])
ax2.set_ylabel(ylabels[1])
ax2.set_ylim(ax2ylim)
ax2.grid(True)

# Line with Error Plot
ax3 = fig.add_subplot(gs[1, 1])
ax3.errorbar(
    seasons,
    ratings_classic,
    yerr=rating_errors,
    fmt="o-",
    color="brown",
    ecolor="darkred",
    capsize=5,
    label=ax3labels[0]
)
ax3.errorbar(
    seasons,
    ratings_recent,
    yerr=rating_errors,
    fmt="s-",
    color="teal",
    ecolor="darkred",
    capsize=5,
    label=ax3labels[1]
)
ax3.set_title(titles[2])
ax3.set_ylabel(ylabels[2])
ax3.legend(title=legend_title)
ax3.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("multidiff_91.pdf", bbox_inches="tight")
