

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.gridspec import GridSpec
from matplotlib.lines import Line2D

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Create a figure and a GridSpec layout
fig = plt.figure(figsize=(10, 5))
gs = GridSpec(1, 2, figure=fig)

# ------- Pie Chart Data for Weather Conditions -------
weather_conditions = ["Sunny", "Cloudy", "Rainy", "Snowy", "Windy"]
percentages = [40, 20, 25, 10, 5]  # Percentages of each weather condition

highlight = (0, 0.1, 0, 0, 0)  # Highlight Cloudy

# ------- Radar Chart Data for Weather Station Performance Metrics -------
metrics = np.array(
    ["Temperature Accuracy", "Humidity Accuracy", "Wind Speed Measurement", "Precipitation Measurement", "Data Transmission"]
)
num_metrics = len(metrics)
performance_values = np.array([0.90, 0.85, 0.88, 0.80, 0.95])
performance_values = np.concatenate((performance_values, [performance_values[0]]))
angles = np.linspace(0, 2 * np.pi, num_metrics, endpoint=False).tolist()
angles += angles[:1]

title_1 = "Distribution of Weather Conditions"
title_2 = "Weather Station Performance Metrics"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#264653", "#2a9d8f", "#e9c46a", "#f4a261", "#e76f51"]

# Create the pie chart in the left panel
ax1 = fig.add_subplot(gs[0, 0])
wedges, texts, autotexts = ax1.pie(
    percentages,
    labels=weather_conditions,
    colors=colors,
    autopct="%1.1f%%",
    startangle=140,
    explode=highlight,
)
ax1.set_title(title_1)
ax1.axis("equal")  # Equal aspect ratio ensures that pie is drawn as a circle.

# Create the radar chart in the right panel
ax2 = fig.add_subplot(gs[0, 1], polar=True)
ax2.fill(angles, performance_values, color="#2a9d8f", alpha=0.25)
ax2.plot(angles, performance_values, color="#2a9d8f", linewidth=2, linestyle='dotted')
ax2.set_xticks(angles[:-1])
ax2.set_xticklabels(metrics)
ax2.set_title(title_2)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("multidiff_95.pdf", bbox_inches="tight")
