

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.gridspec import GridSpec
from matplotlib.lines import Line2D

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Create a figure and a GridSpec layout
fig = plt.figure(figsize=(10, 5))
gs = GridSpec(1, 2, figure=fig)

# ------- Pie Chart Data for Economic Sectors -------
categories = [
    "Agriculture",
    "Industry",
    "Services",
    "Construction",
    "Mining",
]
sizes = [15, 30, 35, 10, 10]  # Percentages of each sector

explode = (0.1, 0, 0.1, 0, 0)  # Highlight Agriculture and Services

# ------- Radar Chart Data for Economic Indicators -------
labels = np.array(
    ["GDP Growth", "Inflation Rate", "Unemployment Rate", "Interest Rate", "Exports"]
)
num_vars = len(labels)
values = np.array([0.03, 0.05, 0.07, 0.02, 0.10])
values = np.concatenate((values, [values[0]]))
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()
angles += angles[:1]

title_1 = "Distribution of Economic Sectors"
title_2 = "Economic Indicators Overview"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#8c564b", "#1f77b4", "#aec7e8", "#ff7f0e", "#2ca02c"]

# Create the pie chart in the left panel
ax1 = fig.add_subplot(gs[0, 0])
wedges, texts, autotexts = ax1.pie(
    sizes,
    labels=categories,
    colors=colors,
    autopct="%1.1f%%",
    startangle=140,
    explode=explode,
    shadow=True,
)
ax1.set_title(title_1, fontsize=14)
ax1.axis("equal")

# Create the radar chart in the right panel
ax2 = fig.add_subplot(gs[0, 1], polar=True)
ax2.fill(angles, values, color="purple", alpha=0.25)
ax2.plot(angles, values, color="purple", linewidth=2, linestyle="dashed")
ax2.set_xticks(angles[:-1])
ax2.set_xticklabels(labels, fontsize=10)
ax2.set_title(title_2, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot with a tight layout to minimize white space
plt.tight_layout()
plt.savefig("multidiff_97.pdf", bbox_inches="tight")
