

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data to plot
land_cover_sizes = [40.0, 25.0, 15.0, 10.0, 7.5, 2.5]  # Forest, Water, Urban, Agriculture, Grassland, Wetlands respectively
land_cover_labels = ["Forest", "Water", "Urban", "Agriculture", "Grassland", "Wetlands"]

# Text labels
title = "Distribution of Land Cover Types"
percent_format = "%1.1f%%"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
explode = (0.1, 0.1, 0.1, 0.1, 0.1, 0.1)  # add explode parameter to separate slices
colors = ["#ff9999", "#66b3ff", "#99ff99", "#ffcc99", "#c2c2f0", "#ffb3e6"]  # custom colors

# Configure plot
fig, ax = plt.subplots(figsize=(6, 6))
ax.pie(
    land_cover_sizes,
    colors=colors,
    autopct=percent_format,
    startangle=140,
    wedgeprops=dict(edgecolor="w"),
    explode=explode,
    labels=land_cover_labels,
)

# Add title
ax.set_title(title, pad=20, fontsize=16, fontweight='bold')

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("pie_22.pdf", bbox_inches="tight")

