

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np  # Importing necessary library for data processing

np.random.seed(0)

# Data to plot
sizes = [22, 17, 19, 15, 20, 11]  # Types of research articles: Biology, Chemistry, Physics, Earth Science, Medicine, Engineering
labels = ["Biology", "Chemistry", "Physics", "Earth Science", "Medicine", "Engineering"]
title = "Distribution of Research Papers Published in Scientific Journal"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(7, 7))  # Adjusted figsize for better visualization
colors = plt.cm.Blues(np.linspace(0.3, 0.7, len(sizes)))  # Use a professional colormap
explode = (0.1,) * len(sizes)  # Separate all slices equally
ax.pie(
    sizes,
    colors=colors,
    labels=labels,  # Added labels to slices
    autopct="%1.1f%%",
    startangle=140,
    wedgeprops=dict(edgecolor="w"),
    explode=explode,
)

# Set aspect ratio to be equal so that pie is drawn as a circle.
ax.axis("equal")

plt.title(title, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("pie_35.pdf", bbox_inches="tight")

