

# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data to plot
labels = ["Anxiety Disorders", "Mood Disorders", "Personality Disorders", "Psychotic Disorders", "Attention Disorders"]
sizes = [25, 20, 15, 10, 30]
xlabel = "Percentage Distribution of Psychological Conditions"
ylabel = "Percentage"
title = "Distribution of Common Psychological Conditions (2023)"
legend_labels = labels

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
plt.figure(figsize=(10, 7))  # Adjust the figure size for better readability

colors = ["#ff9999", "#66b3ff", "#99ff99", "#ffcc99", "#c2c2f0"]  # New color scheme
plt.pie(
    sizes, colors=colors, autopct="%1.1f%%", shadow=True, startangle=140
)
plt.axis("equal")  # Equal aspect ratio ensures that the pie is drawn as a circle.

# Plot configuration
legend_loc = "upper center"
legend_bbox_to_anchor = (0.5, 1.15)
legend_ncol = 5
legend_frameon = False

# Add title
plt.title(title, pad=20)

# Add legend
plt.legend(
    legend_labels,
    loc=legend_loc,
    bbox_to_anchor=legend_bbox_to_anchor,
    frameon=legend_frameon,
    ncol=legend_ncol,
)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("pie_37.pdf", bbox_inches="tight")

