

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data to plot
labels = ["Netflix", "Amazon Prime", "Disney+", "Hulu", "HBO Max"]
sizes = [40, 25, 20, 10, 5]
title = "Market Share of Streaming Platforms"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot setup
fig, ax = plt.subplots(figsize=(8, 8))

# Custom color palette
colors = ["#FF9999", "#66B2FF", "#99FF99", "#FFCC99", "#FFD700"]
explode = (0.1, 0, 0, 0, 0)  # only "explode" the 1st slice (Netflix)

wedges, texts, autotexts = ax.pie(
    sizes,
    explode=explode,
    colors=colors,
    autopct="%1.1f%%",
    shadow=False,
    startangle=140,
    textprops=dict(color="w"),
)

# Adding annotations
bbox_props = dict(boxstyle="round,pad=0.3", fc="white", ec="black", lw=0.72)
kw = dict(arrowprops=dict(arrowstyle="-"), bbox=bbox_props, zorder=0, va="center")

for i, p in enumerate(wedges):
    ang = (p.theta2 - p.theta1) / 2.0 + p.theta1
    y = np.sin(np.deg2rad(ang))
    x = np.cos(np.deg2rad(ang))
    horizontalalignment = {-1: "right", 1: "left"}[int(np.sign(x))]
    connectionstyle = "angle,angleA=0,angleB={}".format(ang)
    kw["arrowprops"].update({"connectionstyle": connectionstyle})
    ax.annotate(
        labels[i],
        xy=(x, y),
        xytext=(1.35 * np.sign(x), 1.2 * y),
        horizontalalignment=horizontalalignment,
        **kw
    )

# Title and equal axis
ax.set_title(title, fontsize=16, x=0.5, y=1)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("pie_43.pdf", bbox_inches="tight")

