
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Define new data for educational expenses
categories = ["Tuition", "Books", "Supplies", "Transport", "Others"]
outer_sizes = [500, 200, 150, 100, 50]  # Expenses distribution for the educational institute
inner_sizes = [300, 100, 80, 40, 30]  # Expenses distribution for a specific academic year

# Text label parameters
title = "Educational Expenses - Institute vs. Academic Year"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(8, 8))

# Define new colors and styles
outer_colors = ["#8B0000", "#000080", "#228B22", "#FFD700", "#A9A9A9"]
inner_colors = ["#CD5C5C", "#4169E1", "#32CD32", "#FFD700", "#C0C0C0"]
outer_hatch = ["/", "", "|", ".", "x"]
inner_hatch = ["\\", "", ".", "-", ""]

explode_outer = (0.05, 0, 0, 0, 0)  # Small explosion for first slice

# Outer ring
wedges, texts, autotexts = ax.pie(
    outer_sizes,
    labels=categories,
    radius=1.2,
    colors=outer_colors,
    explode=explode_outer,
    autopct="%1.1f%%",
    pctdistance=0.85,
    startangle=90,
    wedgeprops=dict(width=0.3, edgecolor="w", hatch="*"),
)

# Inner ring
wedges2, texts2, autotexts2 = ax.pie(
    inner_sizes,
    radius=0.9,
    colors=inner_colors,
    autopct="%1.1f%%",
    pctdistance=0.75,
    startangle=90,
    wedgeprops=dict(width=0.3, edgecolor="w", hatch="o"),
)

# Customizing the autotexts for better visibility
for autotext in autotexts + autotexts2:
    autotext.set_color("black")
    autotext.set_fontsize(10)

# Title for the double layer pie chart
ax.set_title(title, fontsize=16, y=1.05)

# ===================
# Part 4: Saving Output
# ===================
# Improve layout to make room for legend or labels if necessary
plt.tight_layout()

# Show the plot
plt.savefig("pie_52.pdf", bbox_inches="tight")
