
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for the charts
activities = ["Sleeping", "Working", "Leisure", "Others"]
workday_data = [8.0, 9.0, 4.0, 3.0]
weekend_data = [9.0, 1.0, 10.0, 4.0]

# Variables for plot configuration
workday_label = "Workday Activities"
weekend_label = "Weekend Activities"
legend_labels = activities
legend_loc = "upper center"

title_workday = "Workday Time Distribution"
title_weekend = "Weekend Time Distribution"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure with specific dimensions
fig, ax = plt.subplots(2, 1, figsize=(6, 10))

colors = ["#87CEEB", "#228B22", "#F4A460", "#FF4500"]
legend_ncol = 2
legend_frameon = True
wedgeprops_dict = dict(width=0.3)
startangle = 90
counterclock = False

# Workday Activities Donut Chart
ax[0].pie(
    workday_data,
    labels=workday_data,
    colors=colors,
    startangle=startangle,
    counterclock=counterclock,
    wedgeprops=wedgeprops_dict,
)
ax[0].set_title(title_workday)

# Weekend Activities Donut Chart
ax[1].pie(
    weekend_data,
    labels=weekend_data,
    colors=colors,
    startangle=startangle,
    counterclock=counterclock,
    wedgeprops=wedgeprops_dict,
)
ax[1].set_title(title_weekend)

# Add legend
fig.legend(legend_labels, loc=legend_loc, ncol=legend_ncol, frameon=legend_frameon, bbox_to_anchor=(0.5, 0.05))

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent overlap and Show plot
plt.tight_layout()
plt.savefig("pie_58.pdf", bbox_inches="tight")
