

# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for the charts
categories = ["Proteins", "Carbohydrates", "Fats", "Vitamins & Minerals"]
adults_data = [2000, 1500, 700, 300]
teenagers_data = [1800, 1600, 600, 400]

# Variables for plot configuration
adults_label = "Adults"
teenagers_label = "Teenagers"
legend_labels = categories
legend_loc = "lower center"

title_adults = "Daily Caloric Intake by Adults"
title_teenagers = "Daily Caloric Intake by Teenagers"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure with specific dimensions
fig, ax = plt.subplots(2, 1, figsize=(6, 10))

colors = ["#FF6347", "#87CEEB", "#32CD32", "#FFFFE0"]
legend_ncol = 4
legend_frameon = False
wedgeprops_dict = dict(width=0.3, edgecolor='w')
startangle = 90
counterclock = False

# Adults Donut Chart
ax[0].pie(
    adults_data,
    labels=adults_data,
    colors=colors,
    startangle=startangle,
    counterclock=counterclock,
    wedgeprops=wedgeprops_dict,
)
ax[0].set_title(title_adults)

# Teenagers Donut Chart
ax[1].pie(
    teenagers_data,
    labels=teenagers_data,
    colors=colors,
    startangle=startangle,
    counterclock=counterclock,
    wedgeprops=wedgeprops_dict,
)
ax[1].set_title(title_teenagers)

# Add legend
fig.legend(legend_labels, loc=legend_loc, ncol=legend_ncol, frameon=legend_frameon)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent overlap and Show plot
plt.tight_layout()
plt.savefig("pie_59.pdf", bbox_inches="tight")

