

# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# New data for psychology domain
categories = ["Openness", "Conscientiousness", "Extraversion", "Agreeableness", "Neuroticism"]
sizes = [22, 28, 18, 20, 12]  # Example distribution of personality traits

# Variables for plot configuration
title_text = "Distribution of Personality Traits in a Sample Population"  # Updated title for the donut chart

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(8, 8))

# New color scheme
colors = ["#ff6f61", "#6b5b95", "#88b04b", "#f7cac9", "#92a8d1"]
explode = (0.1, 0, 0, 0, 0)  # Highlighting Openness

# The pie function also handles donuts with the 'wedgeprops' argument
wedges, texts, autotexts = ax.pie(
    sizes,
    labels=categories,
    colors=colors,
    autopct="%1.1f%%",
    startangle=90,
    explode=explode,
    wedgeprops=dict(width=0.3, edgecolor="w"),
)

# Draw a circle at the center of pie to make it a donut
centre_circle = plt.Circle((0, 0), 0.70, fc="white")
fig.gca().add_artist(centre_circle)

# Equal aspect ratio ensures that pie is drawn as a circle
ax.axis("equal")

# Set title for the donut chart
ax.set_title(title_text, fontsize=16, fontweight='bold')

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("pie_62.pdf", bbox_inches="tight")

