
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data to plot
sizes = [
    30.0,
    20.0,
    15.0,
    18.0,
    10.0,
    7.0,
]  # Example new data of sports viewership percentages
labels = ["Soccer", "Basketball", "Baseball", "Football", "Tennis", "Others"]

# Plot configuration
title = "Sports Viewership Distribution"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
explode = (0.1, 0, 0.2, 0, 0.2, 0.2)  # add explode parameter to separate slices
title_pad = 20
autopct_format = "%1.1f%%"
startangle = 140
wedgeprops = dict(edgecolor="w", linewidth=2)

# Colors chosen for better visualization
colors = ["#4F81BD", "#C0504D", "#9BBB59", "#8064A2", "#4BACC6", "#F79646"]

# Plot
fig, ax = plt.subplots(figsize=(8, 8))
ax.pie(
    sizes,
    colors=colors,
    autopct=autopct_format,
    startangle=startangle,
    wedgeprops=wedgeprops,
    explode=explode,
    labels=labels,
)
ax.set_title(title, pad=title_pad)  # Set the title with padding

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("pie_71.pdf", bbox_inches="tight")
