

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for new pie chart
categories = ["Crop Production", "Livestock Farming", "Agroforestry", "Fisheries", "Agri-tourism"]
percentages = [40, 25, 20, 10, 5]

# Extracted text variables
chart_title = "Agricultural Activity Breakdown"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Define a tourism-themed color palette
colors = ["#FF6F61", "#6B5B95", "#88B04B", "#F7CAC9", "#92A8D1"]

# Subtle explosion for visual separation
explode = (0.05, 0.05, 0.05, 0.05, 0.05)

# Format for displaying percentages on the chart
autopct_format = "%1.1f%%"

# Legend configuration
legend_location = "best"
legend_bbox_to_anchor = (0, 0.8)

# Create the pie chart
fig, ax = plt.subplots(figsize=(10, 10))  # Adjust figure size for better visualization
patches, texts, autotexts = ax.pie(
    percentages,
    colors=colors,
    autopct=autopct_format,
    startangle=90,
    wedgeprops=dict(edgecolor="black"),
    explode=explode,
    pctdistance=0.75,  # Adjust percentage labels position for better clarity
)

# Optional: creating a donut chart by adding a center circle
donut_circle = plt.Circle((0, 0), 0.60, fc="white")
fig.gca().add_artist(donut_circle)

# Ensure pie is drawn as a circle
ax.axis("equal")

plt.title(chart_title, fontsize=22)
plt.legend(
    patches, categories, loc=legend_location, bbox_to_anchor=legend_bbox_to_anchor
)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot and save with an updated filename
plt.tight_layout()
plt.savefig("pie_76.pdf", bbox_inches="tight")

