
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines

# ===================
# Part 2: Data Preparation
# ===================
# Data for the plot (Philosophical Schools)
philosophical_schools_1 = ["Analytic", "Continental", "Eastern"]
acad_start_1 = [8, 7.5, 7]
acad_bias_1 = [-2.5, -3.0, -2.0]
public_start_1 = [6, 6.5, 5.5]
public_bias_1 = [+1.2, +1.0, +1.8]
ax1_labels = ["Academic Trust Bias", "Public Trust Bias"]

philosophical_schools_2 = ["Pragmatism", "Existentialism", "Confucianism"]
acad_start_2 = [7.8, 7.6, 7.4]
acad_bias_2 = [-1.8, -2.5, -2.2]
public_start_2 = [5.7, 5.8, 6.1]
public_bias_2 = [+1.4, +1.9, +1.6]
ax2_labels = ["Academic Trust Bias", "Public Trust Bias"]

# Chart labels
chart_title = "Trust Levels in Different Philosophical Schools (Bias Index)"
x_label = "Trust Score"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure with two subplots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 5))

# Set the y-axis offsets to be in the middle of each grid
offset = 0.5

# Custom colors
acad_color = "brown"
public_color = "green"

# First subplot (philosophical_schools_1)
for i, school in enumerate(philosophical_schools_1):
    # Academic bias line with arrow and black dots at start and end
    ax1.annotate(
        "",
        xy=(acad_start_1[i], i + offset * 3 / 2),
        xytext=(acad_start_1[i] + acad_bias_1[i], i + offset * 3 / 2),
        arrowprops=dict(arrowstyle="<-", color=acad_color),
    )
    ax1.scatter(
        [acad_start_1[i], acad_start_1[i] + acad_bias_1[i]],
        [i + offset * 3 / 2, i + offset * 3 / 2],
        color="black",
        s=10,
    )
    ax1.annotate(
        f"{acad_bias_1[i]:.2f}",
        (acad_start_1[i] + acad_bias_1[i], i + offset * 1.75),
        color=acad_color,
        ha="right",
        va="center",
    )

    # Public trust bias line with arrow and black dots at start and end
    ax1.annotate(
        "",
        xy=(public_start_1[i], i + offset / 2),
        xytext=(public_start_1[i] + public_bias_1[i], i + offset / 2),
        arrowprops=dict(arrowstyle="<-", color=public_color),
    )
    ax1.scatter(
        [public_start_1[i], public_start_1[i] + public_bias_1[i]],
        [i + offset / 2, i + offset / 2],
        color="black",
        s=10,
    )
    ax1.annotate(
        f"{public_bias_1[i]:.2f}",
        (public_start_1[i] + public_bias_1[i], i + offset * 0.75),
        color=public_color,
        ha="left",
        va="center",
    )

# Second subplot (philosophical_schools_2)
for i, school in enumerate(philosophical_schools_2):
    ax2.annotate(
        "",
        xy=(acad_start_2[i], i + offset * 3 / 2),
        xytext=(acad_start_2[i] + acad_bias_2[i], i + offset * 3 / 2),
        arrowprops=dict(arrowstyle="<-", color=acad_color),
    )
    ax2.scatter(
        [acad_start_2[i], acad_start_2[i] + acad_bias_2[i]],
        [i + offset * 3 / 2, i + offset * 3 / 2],
        color="black",
        s=10,
    )
    ax2.annotate(
        f"{acad_bias_2[i]:.2f}",
        (acad_start_2[i] + acad_bias_2[i], i + offset * 1.75),
        color=acad_color,
        ha="right",
        va="center",
    )

    ax2.annotate(
        "",
        xy=(public_start_2[i], i + offset / 2),
        xytext=(public_start_2[i] + public_bias_2[i], i + offset / 2),
        arrowprops=dict(arrowstyle="<-", color=public_color),
    )
    ax2.scatter(
        [public_start_2[i], public_start_2[i] + public_bias_2[i]],
        [i + offset / 2, i + offset / 2],
        color="black",
        s=10,
    )
    ax2.annotate(
        f"{public_bias_2[i]:.2f}",
        (public_start_2[i] + public_bias_2[i], i + offset * 0.75),
        color=public_color,
        ha="left",
        va="center",
    )

# Set y-axis limits
ax1.set_ylim(0, len(philosophical_schools_1))
ax2.set_ylim(0, len(philosophical_schools_2))

# Set x-axis limits uniformly
ax1.set_xlim(0, 10)
ax2.set_xlim(0, 10)

# Adjust the y-axis tick positions
ax1.set_yticks([i + offset for i in range(len(philosophical_schools_1))])
ax1.set_yticklabels(philosophical_schools_1)
ax2.set_yticks([i + offset for i in range(len(philosophical_schools_2))])
ax2.set_yticklabels(philosophical_schools_2)
ax2.yaxis.tick_right()
ax2.yaxis.set_label_position("right")

# Offset grid lines on the y-axis
ax1.set_yticks([i for i in range(len(philosophical_schools_1))], minor=True)
ax2.set_yticks([i for i in range(len(philosophical_schools_2))], minor=True)
ax1.yaxis.grid(True, which="minor", linewidth=0.5, alpha=0.7, color="black")
ax2.yaxis.grid(True, which="minor", linewidth=0.5, alpha=0.7, color="black")

# Add x-axis grid lines and set gap to 1
ax1.xaxis.set_major_locator(plt.MultipleLocator(1))
ax2.xaxis.set_major_locator(plt.MultipleLocator(1))
ax1.grid(axis="x", linestyle="--", linewidth=0.5)
ax2.grid(axis="x", linestyle="--", linewidth=0.5)

# Create arrow-shaped legend entries with a line that aligns with the arrowhead
acad_arrow = mlines.Line2D(
    [],
    [],
    color=acad_color,
    marker=">",
    linestyle="-",
    markersize=8,
    label=ax1_labels[0],
    linewidth=2,
    markeredgewidth=2,
    markevery=(1, 1),
)
public_arrow = mlines.Line2D(
    [],
    [],
    color=public_color,
    marker=">",
    linestyle="-",
    markersize=8,
    label=ax1_labels[1],
    linewidth=2,
    markeredgewidth=2,
    markevery=(1, 1),
)
fig.legend(handles=[acad_arrow, public_arrow], bbox_to_anchor=(0.45, 0), ncol=2)

acad_arrow = mlines.Line2D(
    [],
    [],
    color=acad_color,
    marker=">",
    linestyle="-",
    markersize=8,
    label=ax2_labels[0],
    linewidth=2,
    markeredgewidth=2,
    markevery=(1, 1),
)
public_arrow = mlines.Line2D(
    [],
    [],
    color=public_color,
    marker=">",
    linestyle="-",
    markersize=8,
    label=ax2_labels[1],
    linewidth=2,
    markeredgewidth=2,
    markevery=(1, 1),
)
fig.legend(handles=[acad_arrow, public_arrow], bbox_to_anchor=(0.85, 0), ncol=2)
# Super title and x label
plt.suptitle(chart_title)
fig.text(0.5, 0.01, x_label, ha="center")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout(rect=[0, 0.03, 1, 0.95])
plt.savefig("quiver_21.pdf", bbox_inches="tight")
