
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for the plot
countries_1 = ["USA", "Canada", "UK"]
perception_start_1 = [8.5, 7.8, 8.2]
perception_change_1 = [-0.5, -0.3, -0.4]
adoption_start_1 = [5.0, 5.5, 6.0]
adoption_change_1 = [+1.2, +1.0, +1.5]
ax1_labels = ["Decrease in Classic Literature Perception", "Increase in New Genres Adoption"]

countries_2 = ["Brazil", "India", "China"]
perception_start_2 = [7.5, 6.8, 8.0]
perception_change_2 = [-1.2, -0.8, -1.0]
adoption_start_2 = [6.0, 5.0, 5.8]
adoption_change_2 = [+0.8, +1.2, +1.0]
ax2_labels = ["Decrease in Classic Literature Perception", "Increase in New Genres Adoption"]

# Chart text labels
xlabel = "Value"
ylabel = "Countries"
title = "Perception and Adoption of Literature Trends"
suptitle = "Literature Studies: Perception vs Adoption Rate"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# Color settings
arrow_color_brown = "brown"
arrow_color_green = "green"
scatter_color = "black"

# Create figure with two subplots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))

# Set the y-axis offsets to be in the middle of each grid
offset = 0.5

# First subplot (countries_1)
for i, country in enumerate(countries_1):
    # Perception line with arrow and brown dots at start and end
    ax1.annotate(
        "",
        xy=(perception_start_1[i], i + offset * 3 / 2),
        xytext=(
            perception_start_1[i] + perception_change_1[i],
            i + offset * 3 / 2,
        ),
        arrowprops=dict(arrowstyle="<-", color=arrow_color_brown),
    )
    ax1.scatter(
        [
            perception_start_1[i],
            perception_start_1[i] + perception_change_1[i],
        ],
        [i + offset * 3 / 2, i + offset * 3 / 2],
        color=scatter_color,
        s=10,
    )
    ax1.annotate(
        f"{perception_change_1[i]:.2f}",
        (
            perception_start_1[i] + perception_change_1[i],
            i + offset * 1.75,
        ),
        color=arrow_color_brown,
        ha="right",
        va="center",
    )

    # Adoption rate line with arrow and green dots at start and end
    ax1.annotate(
        "",
        xy=(adoption_start_1[i], i + offset / 2),
        xytext=(adoption_start_1[i] + adoption_change_1[i], i + offset / 2),
        arrowprops=dict(arrowstyle="<-", color=arrow_color_green),
    )
    ax1.scatter(
        [adoption_start_1[i], adoption_start_1[i] + adoption_change_1[i]],
        [i + offset / 2, i + offset / 2],
        color=scatter_color,
        s=10,
    )
    ax1.annotate(
        f"{adoption_change_1[i]:.2f}",
        (adoption_start_1[i] + adoption_change_1[i], i + offset * 0.75),
        color=arrow_color_green,
        ha="left",
        va="center",
    )

# Second subplot (countries_2)
for i, country in enumerate(countries_2):
    ax2.annotate(
        "",
        xy=(perception_start_2[i], i + offset * 3 / 2),
        xytext=(
            perception_start_2[i] + perception_change_2[i],
            i + offset * 3 / 2,
        ),
        arrowprops=dict(arrowstyle="<-", color=arrow_color_brown),
    )
    ax2.scatter(
        [
            perception_start_2[i],
            perception_start_2[i] + perception_change_2[i],
        ],
        [i + offset * 3 / 2, i + offset * 3 / 2],
        color=scatter_color,
        s=10,
    )
    ax2.annotate(
        f"{perception_change_2[i]:.2f}",
        (
            perception_start_2[i] + perception_change_2[i],
            i + offset * 1.75,
        ),
        color=arrow_color_brown,
        ha="right",
        va="center",
    )

    ax2.annotate(
        "",
        xy=(adoption_start_2[i], i + offset / 2),
        xytext=(adoption_start_2[i] + adoption_change_2[i], i + offset / 2),
        arrowprops=dict(arrowstyle="<-", color=arrow_color_green),
    )
    ax2.scatter(
        [adoption_start_2[i], adoption_start_2[i] + adoption_change_2[i]],
        [i + offset / 2, i + offset / 2],
        color=scatter_color,
        s=10,
    )
    ax2.annotate(
        f"{adoption_change_2[i]:.2f}",
        (adoption_start_2[i] + adoption_change_2[i], i + offset * 0.75),
        color=arrow_color_green,
        ha="left",
        va="center",
    )

# set y-axis limits
ax1.set_ylim(0, len(countries_1))
ax2.set_ylim(0, len(countries_2))

# Set x-axis limits uniformly
ax1.set_xlim(0, 10)
ax2.set_xlim(0, 10)

# Adjust the y-axis tick positions
ax1.set_yticks([i + offset for i in range(len(countries_1))])
ax1.set_yticklabels(countries_1)
ax2.set_yticks([i + offset for i in range(len(countries_2))])
ax2.set_yticklabels(countries_2)
ax2.yaxis.tick_right()
ax2.yaxis.set_label_position("right")

# Offset grid lines on the y-axis
ax1.set_yticks([i for i in range(len(countries_1))], minor=True)
ax2.set_yticks([i for i in range(len(countries_2))], minor=True)
ax1.yaxis.grid(True, which="minor", linewidth=0.5, alpha=0.7, color="black")
ax2.yaxis.grid(True, which="minor", linewidth=0.5, alpha=0.7, color="black")

# add x-axis grid lines and set gap is 1
ax1.xaxis.set_major_locator(plt.MultipleLocator(1))
ax2.xaxis.set_major_locator(plt.MultipleLocator(1))
ax1.grid(axis="x", linestyle="--", linewidth=0.5)
ax2.grid(axis="x", linestyle="--", linewidth=0.5)

# Create arrow-shaped legend entries with a line that aligns with the arrowhead
brown_arrow = mlines.Line2D(
    [],
    [],
    color=arrow_color_brown,
    marker=">",
    linestyle="-",
    markersize=8,
    label=ax1_labels[0],
    linewidth=2,
    markeredgewidth=2,
    markevery=(1, 1),
)
green_arrow = mlines.Line2D(
    [],
    [],
    color=arrow_color_green,
    marker=">",
    linestyle="-",
    markersize=8,
    label=ax1_labels[1],
    linewidth=2,
    markeredgewidth=2,
    markevery=(1, 1),
)
fig.legend(handles=[brown_arrow, green_arrow], bbox_to_anchor=(0.45, 0))

brown_arrow = mlines.Line2D(
    [],
    [],
    color=arrow_color_brown,
    marker=">",
    linestyle="-",
    markersize=8,
    label=ax2_labels[0],
    linewidth=2,
    markeredgewidth=2,
    markevery=(1, 1),
)
green_arrow = mlines.Line2D(
    [],
    [],
    color=arrow_color_green,
    marker=">",
    linestyle="-",
    markersize=8,
    label=ax2_labels[1],
    linewidth=2,
    markeredgewidth=2,
    markevery=(1, 1),
)
fig.legend(handles=[brown_arrow, green_arrow], bbox_to_anchor=(0.85, 0))

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.suptitle(suptitle, fontsize=14)
plt.tight_layout(rect=[0, 0.03, 1, 0.95])
plt.savefig("quiver_22.pdf", bbox_inches="tight")
