
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines
import matplotlib.patches as mpatches

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Define the vector field function (example: wind patterns)
def wind_field(X, Y):
    U = np.sin(np.pi * X) * np.cos(np.pi * Y)
    V = -np.cos(np.pi * X) * np.sin(np.pi * Y)
    return U, V

def temperature_field(X, Y):
    U = -1 - X**2 + Y
    V = 1 + X - Y**2
    return U, V

# Create a grid of points
x = np.linspace(-1, 1, 10)
y = np.linspace(-1, 1, 10)
X, Y = np.meshgrid(x, y)

# Compute the vector field
U, V = wind_field(X, Y)

# Compute the temperature field
U_temp, V_temp = temperature_field(X, Y)

# Plot temperature variation curves
x = np.linspace(-1, 1, 100)
xlabel = "Longitude (Degrees)"
ylabel = "Latitude (Degrees)"
patch_labels = ["Wind Patterns", "Temperature Variations"]
line_labels = [
    "Temperature Curve 1",
    "Temperature Curve 2",
    "Temperature Curve 3",
    "Temperature Curve 4"
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(8, 6))
plt.quiver(X, Y, U, V, color="#4caf50", alpha=0.6)  # Green
plt.quiver(X, Y, U_temp, V_temp, color="#3f51b5", alpha=0.6)  # Blue
plt.plot(
    x, np.sin(np.pi * x), color="#ff9800", linestyle="-", linewidth=1.5
)  # Orange, solid
plt.plot(
    x, np.cos(np.pi * x), color="#9c27b0", linestyle="--", linewidth=1.5
)  # Purple, dashed
plt.plot(
    x, np.sin(2 * np.pi * x), color="#e91e63", linestyle="-.", linewidth=1.5
)  # Pink, dash-dot
plt.plot(
    x, np.cos(2 * np.pi * x), color="#607d8b", linestyle=":", linewidth=1.5
)  # Blue-grey, dotted

# Add labels and legend
plt.xlabel(xlabel, fontsize=14, style="italic")
plt.ylabel(ylabel, fontsize=14, style="italic")

green_patch = mpatches.Patch(color="#4caf50", label=patch_labels[0], alpha=0.6)
blue_patch = mpatches.Patch(color="#3f51b5", label=patch_labels[1], alpha=0.6)

# Create legend for curves
temp_curve1 = mlines.Line2D(
    [], [], color="#ff9800", linestyle="-", linewidth=1.5, label=line_labels[0]
)
temp_curve2 = mlines.Line2D(
    [], [], color="#9c27b0", linestyle="--", linewidth=1.5, label=line_labels[1]
)
temp_curve3 = mlines.Line2D(
    [], [], color="#e91e63", linestyle="-.", linewidth=1.5, label=line_labels[2]
)
temp_curve4 = mlines.Line2D(
    [], [], color="#607d8b", linestyle=":", linewidth=1.5, label=line_labels[3]
)

# Combine all legend handles
handles = [
    green_patch,
    blue_patch,
    temp_curve1,
    temp_curve2,
    temp_curve3,
    temp_curve4,
]

# Add the legend to the plot with specified location
plt.legend(handles=handles, loc="lower left")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("quiver_27.pdf", bbox_inches="tight")
