
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines
import matplotlib.patches as mpatches

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Define the vector field function
def vector_field(X, Y):
    # Function simulating GDP change with respect to trade balance
    U = -0.5 * Y
    V = 0.5 * X
    return U, V

def modified_vector_field(X, Y):
    # Modified function simulating different economic scenario
    U = -0.5 - 0.2 * X**2 + 0.1 * Y
    V = 0.3 + 0.1 * X - 0.2 * Y**2
    return U, V

# Create a grid of points
x = np.linspace(200, 800, 10)  # GDP in billion dollars
y = np.linspace(-300, 300, 10)  # Trade balance in billion dollars
X, Y = np.meshgrid(x, y)

# Compute the vector fields
U, V = vector_field(X, Y)
U_mod, V_mod = modified_vector_field(X, Y)

# Generate data for economic curves
x = np.linspace(200, 800, 100)

# Labels and legends
xlabel = "GDP (Billion $)"
ylabel = "Trade Balance (Billion $)"
patch_labels = ["Actual Scenario", "Predicted Scenario"]
line_labels = ["Scenario 1", "Scenario 2", "Economic Model 1", "Economic Model 2"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(8, 6))
plt.quiver(X, Y, U, V, color="#ff9999", alpha=0.6)
plt.quiver(X, Y, U_mod, V_mod, color="#66b3ff", alpha=0.6)
plt.plot(x, 0.005 * x**0.8, color="#99ff99", linestyle='--')
plt.plot(x, 0.004 * x**0.9, color="#ffcc99", linestyle=':')
plt.plot(x, 0.003 * x**1.0, color="#c2c2f0", linestyle='-.')
plt.plot(x, 0.006 * x**1.1, color="#ffb3e6", linestyle='-')

# Add labels and legend
plt.xlabel(xlabel, fontsize=14, style="italic")
plt.ylabel(ylabel, fontsize=14, style="italic")

red_patch = mpatches.Patch(color="#ff9999", label=patch_labels[0], alpha=0.6)
blue_patch = mpatches.Patch(color="#66b3ff", label=patch_labels[1], alpha=0.6)

# Create legend for curves
train_line = mlines.Line2D([], [], color="#99ff99", label=line_labels[0], linestyle='--')
test_line = mlines.Line2D([], [], color="#ffcc99", label=line_labels[1], linestyle=':')
sindy_train_line = mlines.Line2D([], [], color="#c2c2f0", label=line_labels[2], linestyle='-.')
sindy_test_line = mlines.Line2D([], [], color="#ffb3e6", label=line_labels[3], linestyle='-')

# Combine all legend handles
handles = [
    red_patch,
    blue_patch,
    train_line,
    test_line,
    sindy_train_line,
    sindy_test_line,
]

# Add the legend to the plot with specified location
plt.legend(handles=handles, loc="lower left")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("quiver_28.pdf", bbox_inches="tight")
