

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines
import matplotlib.patches as mpatches


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)


# Define the vector field function for seating preferences
def front_seating(X, Y):
    U = -Y
    V = X
    return U, V


def rear_seating(X, Y):
    U = -1 - X**2 + Y
    V = 1 + X - Y**2
    return U, V


# Create a grid of points for the vector field
x = np.linspace(0, 30, 10)
y = np.linspace(0, 30, 10)
X, Y = np.meshgrid(x, y)

# Compute the vector field for front and rear seating
U_front, V_front = front_seating(X, Y)
U_rear, V_rear = rear_seating(X, Y)

# Simulate popularity paths as curves
x = np.linspace(5, 25, 100)
xlabel = "Screen Width (meters)"
ylabel = "Screen Height (meters)"
patch_labels = ["Front Seating Preference", "Rear Seating Preference"]
line_labels = ["Average Path", "Popular Path A", "Popular Path B", "Popular Path C"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(8, 6))
plt.quiver(X, Y, U_front, V_front, color="#1f77b4", alpha=0.7)  # Blue color for front seating
plt.quiver(X, Y, U_rear, V_rear, color="#ff7f0e", alpha=0.7)  # Orange color for rear seating
plt.plot(x, 10 + 4 * np.sin(x / 4), color="#2ca02c", linestyle="--", linewidth=1.5)  # Green dashed line
plt.plot(x, 8 + 5 * np.cos(x / 3), color="#d62728", linestyle=":", linewidth=1.5)  # Red dotted line
plt.plot(x, 6 + 4 * np.sin(x / 5), color="#9467bd", linestyle="-.", linewidth=1.5)  # Purple dash-dot line
plt.plot(x, 5 + 4 * np.cos(x / 6), color="#8c564b", linestyle="-", linewidth=1.5)  # Brown solid line

# Add labels and legend
plt.xlabel(xlabel, fontsize=14, style="italic")
plt.ylabel(ylabel, fontsize=14, style="italic")

front_patch = mpatches.Patch(color="#1f77b4", label=patch_labels[0], alpha=0.7)
rear_patch = mpatches.Patch(color="#ff7f0e", label=patch_labels[1], alpha=0.7)

# Create legend for curves
average_line = mlines.Line2D([], [], color="#2ca02c", linestyle="--", linewidth=1.5, label=line_labels[0])
popular_path_a = mlines.Line2D([], [], color="#d62728", linestyle=":", linewidth=1.5, label=line_labels[1])
popular_path_b = mlines.Line2D([], [], color="#9467bd", linestyle="-.", linewidth=1.5, label=line_labels[2])
popular_path_c = mlines.Line2D([], [], color="#8c564b", linestyle="-", linewidth=1.5, label=line_labels[3])

# Combine all legend handles
handles = [
    front_patch,
    rear_patch,
    average_line,
    popular_path_a,
    popular_path_b,
    popular_path_c,
]

# Add the legend to the plot with specified location
plt.legend(handles=handles, loc="lower left")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("quiver_29.pdf", bbox_inches="tight")

