
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Define the vector field function
def vector_field(X, Y):
    # Simulating a weather pattern with a wind vector field
    U = -np.sin(Y) * np.cos(X)
    V = np.cos(Y) * np.sin(X)
    return U, V

# Create a grid of points representing a geographic area
x = np.linspace(-5.0, 5.0, 20)
y = np.linspace(-5.0, 5.0, 20)
X, Y = np.meshgrid(x, y)

# Compute the vector field
U, V = vector_field(X, Y)

# Labels and title
xlabel = "Longitude"
ylabel = "Latitude"
title = "Weather Patterns: Simulated Wind Vectors"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(6, 5))

# Plot the vector field
ax.quiver(X, Y, U, V, color="#2a9d8f")

# Set labels and title
ax.set_xlabel(xlabel, fontsize=12, fontweight="bold")
ax.set_ylabel(ylabel, fontsize=12, fontweight="bold")
ax.set_title(title, fontsize=14, fontweight="bold", color="#264653")

# Show grid with a specific style
ax.grid(True, linestyle=":", alpha=0.8, color="#e9c46a")

# Enhance the visual quality of the plot
ax.set_aspect("equal")
ax.set_facecolor("#f0f8ff")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("quiver_30.pdf", bbox_inches="tight")
