
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np  # Import here as instructed

# Seed for reproducibility
np.random.seed(0)

# Define the vector field function to represent traffic flow
def vector_field(X, Y):
    U = -Y / (X**2 + Y**2 + 1) * np.exp(-(X**2 + Y**2) / 2)
    V = X / (X**2 + Y**2 + 1) * np.exp(-(X**2 + Y**2) / 2)
    return U, V

# Create a finer grid of points for traffic flow representation
x = np.linspace(-10.0, 10.0, 20)
y = np.linspace(-10.0, 10.0, 20)
X, Y = np.meshgrid(x, y)

# Compute the vector field
U, V = vector_field(X, Y)
xlabel = "Longitude"
ylabel = "Latitude"
title = "Traffic Flow Dynamics"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(8, 6))

# Use a more contrasting and vibrant color scheme
colors = np.sqrt(U**2 + V**2)
ax.quiver(X, Y, U, V, colors, cmap="plasma", pivot="middle")

# Add several streamlines to the vector field plot
strm = ax.streamplot(X, Y, U, V, color="black", linewidth=0.5, density=1.0)

# Set labels and title
ax.set_xlabel(xlabel, fontsize=12, fontweight="bold")
ax.set_ylabel(ylabel, fontsize=12, fontweight="bold")
ax.set_title(title, fontsize=14, fontweight="bold")

# Show grid
ax.grid(True, linestyle="--", alpha=0.7)

# Adjust the aspect ratio
ax.set_aspect("equal")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()

# Display the plot
plt.savefig("quiver_33.pdf", bbox_inches="tight")
