

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Define the vector field function for wind patterns around a mountain peak
def vector_field(X, Y):
    # Calculate the direction outward from the origin (0, 0)
    U = X
    V = Y
    return U, V

# Create a finer grid of points
x = np.linspace(-10.0, 10.0, 30)
y = np.linspace(-10.0, 10.0, 30)
X, Y = np.meshgrid(x, y)

# Compute the vector field
U, V = vector_field(X, Y)
xlabel = "X Coordinate (km)"
ylabel = "Y Coordinate (km)"
title = "Wind Patterns around a Mountain Peak"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(8, 6))

# Use a vibrant and engaging color scheme to reflect the environmental theme
colors = np.sqrt(U**2 + V**2)
ax.quiver(X, Y, U, V, colors, cmap="plasma", scale=50)

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Show grid with specific style
ax.grid(True, linestyle="--", alpha=0.7)

# Adjust the aspect ratio
ax.set_aspect("equal")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()

# Display the plot
plt.savefig("quiver_34.pdf", bbox_inches="tight")
