

# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)


# Define the vector field function symbolizing ocean currents
def vector_field(X, Y):
    # Vectors representing ocean currents
    U = -Y   # Currents flowing upward
    V = X    # Currents flowing to the right
    return U, V


# Create a finer grid of points
x = np.linspace(-10.0, 10.0, 25)
y = np.linspace(-10.0, 10.0, 25)
X, Y = np.meshgrid(x, y)

# Compute the vector field
U, V = vector_field(X, Y)
xlabel = "Longitude"
ylabel = "Latitude"
title = "Ocean Currents Simulation"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(6, 5))

# Use a philosophical color scheme
colors = np.sqrt(U**2 + V**2)
quiver = ax.quiver(X, Y, U, V, colors, cmap="plasma")

# Add streamlines to the vector field plot to enhance flow representation
strm = ax.streamplot(X, Y, U, V, color='white', linewidth=0.8)

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Show subtle grid
ax.grid(True, linestyle="--", alpha=0.3)

# Adjust the aspect ratio
ax.set_aspect("equal")

# Apply a dark background
ax.set_facecolor('black')

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()

# Display the plot
plt.savefig("quiver_35.pdf", bbox_inches="tight")

