
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for the plot (Technology Companies)
companies_group_1 = ["TechCorp", "InnovateX", "SoftSolutions"]
user_base_initial_1 = [500, 600, 550]
user_base_change_1 = [50, 60, 55]
revenue_initial_1 = [700, 850, 800]
revenue_change_1 = [70, 90, 80]
ax1_labels = ["Revenue Growth", "User Base Growth"]

companies_group_2 = ["NextGenTech", "AlphaSoft", "DataPioneers"]
user_base_initial_2 = [450, 500, 480]
user_base_change_2 = [45, 50, 48]
revenue_initial_2 = [600, 700, 650]
revenue_change_2 = [65, 78, 70]
ax2_labels = ["Revenue Growth", "User Base Growth"]

# Custom Label Texts
xlabel_1 = "Growth Metrics (in Thousands)"
xlabel_2 = "Growth Metrics (in Thousands)"
ylabel_1 = "Companies"
ylabel_2 = "Companies"
title_1 = "Growth of User Base and Revenue in 2022\n(Group 1)"
title_2 = "Growth of User Base and Revenue in 2022\n(Group 2)"
suptitle = "Visualization of Technology Companies' Growth"
legend_labels = ["Revenue Growth", "User Base Growth"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure with two subplots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 5))

# Set the y-axis offsets to be in the middle of each grid
offset = 0.5

# Define colors
color_revenue = "mediumseagreen"
color_users = "royalblue"
color_black = "black"

# First subplot (companies_group_1)
for i, company in enumerate(companies_group_1):
    # Revenue growth line with arrow and black dots at start and end
    ax1.annotate(
        "",
        xy=(revenue_initial_1[i], i + offset * 3 / 2),
        xytext=(revenue_initial_1[i] + revenue_change_1[i], i + offset * 3 / 2),
        arrowprops=dict(arrowstyle="<-", color=color_revenue),
    )
    ax1.scatter(
        [revenue_initial_1[i], revenue_initial_1[i] + revenue_change_1[i]],
        [i + offset * 3 / 2, i + offset * 3 / 2],
        color=color_black,
        s=10,
    )
    ax1.annotate(
        f"{revenue_change_1[i]:.2f}",
        (revenue_initial_1[i] + revenue_change_1[i], i + offset * 1.75),
        color=color_revenue,
        ha="right",
        va="center",
    )

    # User base growth line with arrow and black dots at start and end
    ax1.annotate(
        "",
        xy=(user_base_initial_1[i], i + offset / 2),
        xytext=(
            user_base_initial_1[i] + user_base_change_1[i],
            i + offset / 2,
        ),
        arrowprops=dict(arrowstyle="<-", color=color_users),
    )
    ax1.scatter(
        [
            user_base_initial_1[i],
            user_base_initial_1[i] + user_base_change_1[i],
        ],
        [i + offset / 2, i + offset / 2],
        color=color_black,
        s=10,
    )
    ax1.annotate(
        f"{user_base_change_1[i]:.2f}",
        (user_base_initial_1[i] + user_base_change_1[i], i + offset * 0.75),
        color=color_users,
        ha="left",
        va="center",
    )

# Second subplot (companies_group_2)
for i, company in enumerate(companies_group_2):
    ax2.annotate(
        "",
        xy=(revenue_initial_2[i], i + offset * 3 / 2),
        xytext=(revenue_initial_2[i] + revenue_change_2[i], i + offset * 3 / 2),
        arrowprops=dict(arrowstyle="<-", color=color_revenue),
    )
    ax2.scatter(
        [revenue_initial_2[i], revenue_initial_2[i] + revenue_change_2[i]],
        [i + offset * 3 / 2, i + offset * 3 / 2],
        color=color_black,
        s=10,
    )
    ax2.annotate(
        f"{revenue_change_2[i]:.2f}",
        (revenue_initial_2[i] + revenue_change_2[i], i + offset * 1.75),
        color=color_revenue,
        ha="right",
        va="center",
    )

    ax2.annotate(
        "",
        xy=(user_base_initial_2[i], i + offset / 2),
        xytext=(
            user_base_initial_2[i] + user_base_change_2[i],
            i + offset / 2,
        ),
        arrowprops=dict(arrowstyle="<-", color=color_users),
    )
    ax2.scatter(
        [
            user_base_initial_2[i],
            user_base_initial_2[i] + user_base_change_2[i],
        ],
        [i + offset / 2, i + offset / 2],
        color=color_black,
        s=10,
    )
    ax2.annotate(
        f"{user_base_change_2[i]:.2f}",
        (user_base_initial_2[i] + user_base_change_2[i], i + offset * 0.75),
        color=color_users,
        ha="left",
        va="center",
    )

# Set y-axis limits
ax1.set_ylim(0, len(companies_group_1))
ax2.set_ylim(0, len(companies_group_2))

# Set x-axis limits uniformly
ax1.set_xlim(0, 1000)
ax2.set_xlim(0, 1000)

# Adjust the y-axis tick positions
ax1.set_yticks([i + offset for i in range(len(companies_group_1))])
ax1.set_yticklabels(companies_group_1)
ax2.set_yticks([i + offset for i in range(len(companies_group_2))])
ax2.set_yticklabels(companies_group_2)
ax2.yaxis.tick_right()
ax2.yaxis.set_label_position("right")

# Offset grid lines on the y-axis
ax1.set_yticks([i for i in range(len(companies_group_1))], minor=True)
ax2.set_yticks([i for i in range(len(companies_group_2))], minor=True)
ax1.yaxis.grid(True, which="minor", linewidth=0.5, alpha=0.7, color=color_black)
ax2.yaxis.grid(True, which="minor", linewidth=0.5, alpha=0.7, color=color_black)

# Add x-axis grid lines and set gap to 100
ax1.xaxis.set_major_locator(plt.MultipleLocator(100))
ax2.xaxis.set_major_locator(plt.MultipleLocator(100))
ax1.grid(axis="x", linestyle="--", linewidth=0.5)
ax2.grid(axis="x", linestyle="--", linewidth=0.5)

# Create arrow-shaped legend entries with a line that aligns with the arrowhead
green_arrow = mlines.Line2D(
    [],
    [],
    color=color_revenue,
    marker=">",
    linestyle="-",
    markersize=8,
    label=legend_labels[0],
    linewidth=2,
    markeredgewidth=2,
    markevery=(1, 1),
)
blue_arrow = mlines.Line2D(
    [],
    [],
    color=color_users,
    marker=">",
    linestyle="-",
    markersize=8,
    label=legend_labels[1],
    linewidth=2,
    markeredgewidth=2,
    markevery=(1, 1),
)
fig.legend(handles=[green_arrow, blue_arrow], bbox_to_anchor=(0.5, 0), ncol=2)

# Set titles and labels
ax1.set_title(title_1)
ax1.set_xlabel(xlabel_1)
ax1.set_ylabel(ylabel_1)

ax2.set_title(title_2)
ax2.set_xlabel(xlabel_2)
ax2.set_ylabel(ylabel_2)

fig.suptitle(suptitle, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout(rect=[0, 0.03, 1, 0.95])
plt.savefig("quiver_40.pdf", bbox_inches="tight")
