
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for the plot (Religion Domain)
regions_1 = ["Christianity", "Islam", "Hinduism"]
attendance_rate_1 = [70, 60, 50]  # Average attendance rate in percentage
attendance_rate_change_1 = [5, 7, 3]  # Change in attendance rate in percentage
engagement_rate_1 = [65, 55, 40]  # Engagement rate in percentage
engagement_rate_change_1 = [6, 5, 4]  # Change in engagement rate in percentage
ax1_labels = ["Attendance Rate Change (%)", "Engagement Rate Change (%)"]

regions_2 = ["Buddhism", "Judaism", "Sikhism"]
attendance_rate_2 = [45, 30, 25]  # Average attendance rate in percentage
attendance_rate_change_2 = [4, 3, 2]  # Change in attendance rate in percentage
engagement_rate_2 = [35, 20, 15]  # Engagement rate in percentage
engagement_rate_change_2 = [3, 2, 2]  # Change in engagement rate in percentage
ax2_labels = ["Attendance Rate Change (%)", "Engagement Rate Change (%)"]

# Text labels
xlabel = "Percentage"
ylabel = "Religious Categories"
title1 = "Religious Attendance Trends (Group 1)"
title2 = "Religious Attendance Trends (Group 2)"
supertitle = "Religious Attendance and Engagement Trends"
legendlabels = ["Attendance Rate Change (%)", "Engagement Rate Change (%)"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure with two subplots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))

# Set the y-axis offsets to be in the middle of each grid
offset = 0.5

# Color definitions
attendance_color = "#FF5733"  # Bright Orange
engagement_color = "#33C3F0"  # Bright Blue

# First subplot (regions_1)
for i, region in enumerate(regions_1):
    # Attendance Rate change line with arrow and black dots at start and end
    ax1.annotate(
        "",
        xy=(attendance_rate_1[i], i + offset * 3 / 2),
        xytext=(
            attendance_rate_1[i] + attendance_rate_change_1[i],
            i + offset * 3 / 2,
        ),
        arrowprops=dict(arrowstyle="<-", color=attendance_color),
    )
    ax1.scatter(
        [
            attendance_rate_1[i],
            attendance_rate_1[i] + attendance_rate_change_1[i],
        ],
        [i + offset * 3 / 2, i + offset * 3 / 2],
        color="black",
        s=25,
    )
    ax1.annotate(
        f"{attendance_rate_change_1[i]:.2f}",
        (attendance_rate_1[i] + attendance_rate_change_1[i], i + offset * 1.75),
        color=attendance_color,
        ha="right",
        va="center",
    )

    # Engagement Rate change line with arrow and black dots at start and end
    ax1.annotate(
        "",
        xy=(engagement_rate_1[i], i + offset / 2),
        xytext=(engagement_rate_1[i] + engagement_rate_change_1[i], i + offset / 2),
        arrowprops=dict(arrowstyle="<-", color=engagement_color),
    )
    ax1.scatter(
        [engagement_rate_1[i], engagement_rate_1[i] + engagement_rate_change_1[i]],
        [i + offset / 2, i + offset / 2],
        color="black",
        s=25,
    )
    ax1.annotate(
        f"{engagement_rate_change_1[i]:.2f}",
        (engagement_rate_1[i] + engagement_rate_change_1[i], i + offset * 0.75),
        color=engagement_color,
        ha="left",
        va="center",
    )

# Second subplot (regions_2)
for i, region in enumerate(regions_2):
    ax2.annotate(
        "",
        xy=(attendance_rate_2[i], i + offset * 3 / 2),
        xytext=(
            attendance_rate_2[i] + attendance_rate_change_2[i],
            i + offset * 3 / 2,
        ),
        arrowprops=dict(arrowstyle="<-", color=attendance_color),
    )
    ax2.scatter(
        [
            attendance_rate_2[i],
            attendance_rate_2[i] + attendance_rate_change_2[i],
        ],
        [i + offset * 3 / 2, i + offset * 3 / 2],
        color="black",
        s=25,
    )
    ax2.annotate(
        f"{attendance_rate_change_2[i]:.2f}",
        (attendance_rate_2[i] + attendance_rate_change_2[i], i + offset * 1.75),
        color=attendance_color,
        ha="right",
        va="center",
    )

    ax2.annotate(
        "",
        xy=(engagement_rate_2[i], i + offset / 2),
        xytext=(engagement_rate_2[i] + engagement_rate_change_2[i], i + offset / 2),
        arrowprops=dict(arrowstyle="<-", color=engagement_color),
    )
    ax2.scatter(
        [engagement_rate_2[i], engagement_rate_2[i] + engagement_rate_change_2[i]],
        [i + offset / 2, i + offset / 2],
        color="black",
        s=25,
    )
    ax2.annotate(
        f"{engagement_rate_change_2[i]:.2f}",
        (engagement_rate_2[i] + engagement_rate_change_2[i], i + offset * 0.75),
        color=engagement_color,
        ha="left",
        va="center",
    )

# set y-axis limits
ax1.set_ylim(0, len(regions_1))
ax2.set_ylim(0, len(regions_2))

# Set x-axis limits uniformly
ax1.set_xlim(0, 80)
ax2.set_xlim(0, 80)

# Adjust the y-axis tick positions
ax1.set_yticks([i + offset for i in range(len(regions_1))])
ax1.set_yticklabels(regions_1)
ax2.set_yticks([i + offset for i in range(len(regions_2))])
ax2.set_yticklabels(regions_2)
ax2.yaxis.tick_right()
ax2.yaxis.set_label_position("right")

# Offset grid lines on the y-axis
ax1.set_yticks([i for i in range(len(regions_1))], minor=True)
ax2.set_yticks([i for i in range(len(regions_2))], minor=True)
ax1.yaxis.grid(True, which="minor", linewidth=0.5, alpha=0.7, color="grey")
ax2.yaxis.grid(True, which="minor", linewidth=0.5, alpha=0.7, color="grey")

# add x-axis grid lines and set gap is 10
ax1.xaxis.set_major_locator(plt.MultipleLocator(10))
ax2.xaxis.set_major_locator(plt.MultipleLocator(10))
ax1.grid(axis="x", linestyle="--", linewidth=0.5)
ax2.grid(axis="x", linestyle="--", linewidth=0.5)

# Create arrow-shaped legend entries with a line that aligns with the arrowhead
orange_arrow = mlines.Line2D(
    [],
    [],
    color=attendance_color,
    marker=">",
    linestyle="-",
    markersize=8,
    label=ax1_labels[0],
    linewidth=2,
    markeredgewidth=2,
    markevery=(1, 1),
)
blue_arrow = mlines.Line2D(
    [],
    [],
    color=engagement_color,
    marker=">",
    linestyle="-",
    markersize=8,
    label=ax1_labels[1],
    linewidth=2,
    markeredgewidth=2,
    markevery=(1, 1),
)
fig.legend(handles=[orange_arrow, blue_arrow], bbox_to_anchor=(0.45, 0), ncol=2)

orange_arrow = mlines.Line2D(
    [],
    [],
    color=attendance_color,
    marker=">",
    linestyle="-",
    markersize=8,
    label=ax2_labels[0],
    linewidth=2,
    markeredgewidth=2,
    markevery=(1, 1),
)
blue_arrow = mlines.Line2D(
    [],
    [],
    color=engagement_color,
    marker=">",
    linestyle="-",
    markersize=8,
    label=ax2_labels[1],
    linewidth=2,
    markeredgewidth=2,
    markevery=(1, 1),
)
fig.legend(handles=[orange_arrow, blue_arrow], bbox_to_anchor=(0.95, 0), ncol=2)

# Update plot titles and labels
ax1.set_title(title1)
ax2.set_title(title2)
fig.suptitle(supertitle, y=1.02)
fig.supxlabel(xlabel)
fig.supylabel(ylabel)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("quiver_46.pdf", bbox_inches="tight")
