

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines
import matplotlib.patches as mpatches

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Define the vector field function for normal signal
def signal_vector_field(X, Y):
    U = -0.8 * Y + X
    V = 0.6 * X - Y
    return U, V

def modified_signal_vector_field(X, Y):
    U = -0.6 - X * 0.9 + Y * 0.8
    V = 0.9 * X - 0.5 * Y**1.5
    return U, V

# Create a grid of points representing locations
x = np.linspace(0, 1, 10)
y = np.linspace(0, 1, 10)
X, Y = np.meshgrid(x, y)

# Compute the vector field
U, V = signal_vector_field(X, Y)

# Compute the modified vector field
U_mod, V_mod = modified_signal_vector_field(X, Y)

# Plot the curves representing different signal paths
x = np.linspace(0.3, 0.6, 100)
xlabel = "Distance (m)"
ylabel = "Signal Strength (dB)"
patch_labels = ["Normal Signal Field", "Modified Signal Field"]
line_labels = ["Path X", "Path Y", "Path Z", "Path W"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(8, 6))

# Quiver plots for signal fields
normal_color = "#4682B4"
modified_color = "#DC143C"

plt.quiver(X, Y, U, V, color=normal_color, alpha=0.6)  # Normal Field
plt.quiver(X, Y, U_mod, V_mod, color=modified_color, alpha=0.6)  # Modified Field

# Plot different signal paths
plt.plot(x, 0.09 / (x**1.2), color="#32CD32", linestyle="-", linewidth=2)
plt.plot(x, 0.08 / (x**1.2 + 0.04), color="#FFA500", linestyle="--", linewidth=2)
plt.plot(x, 0.075 / (x**1 + 0.04), color="#8B4513", linestyle="-.", linewidth=2)
plt.plot(x, 0.12 / (x**1 + 0.05), color="#000080", linestyle=":", linewidth=2)

# Add labels and legend
plt.xlabel(xlabel, fontsize=14, style="italic")
plt.ylabel(ylabel, fontsize=14, style="italic")

# Patches for vector fields
blue_patch = mpatches.Patch(color=normal_color, label=patch_labels[0], alpha=0.6)
red_patch = mpatches.Patch(color=modified_color, label=patch_labels[1], alpha=0.6)

# Lines for signal paths
path_x = mlines.Line2D([], [], color="#32CD32", linestyle="-", label=line_labels[0], linewidth=2)
path_y = mlines.Line2D([], [], color="#FFA500", linestyle="--", label=line_labels[1], linewidth=2)
path_z = mlines.Line2D([], [], color="#8B4513", linestyle="-.", label=line_labels[2], linewidth=2)
path_w = mlines.Line2D([], [], color="#000080", linestyle=":", label=line_labels[3], linewidth=2)

# Combine all legend handles
handles = [blue_patch, red_patch, path_x, path_y, path_z, path_w]

# Add the legend to the plot with specified location
plt.legend(handles=handles, loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("quiver_52.pdf", bbox_inches="tight")
