
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Define the media influence field function
def media_influence_field(X, Y):
    # Simplified media influence vector field
    U = np.sin(np.pi * X / 100) * np.cos(np.pi * Y / 100)
    V = -np.cos(np.pi * X / 100) * np.sin(np.pi * Y / 100)
    return U, V

# Create a grid of points
x = np.linspace(0.0, 100.0, 20)
y = np.linspace(0.0, 100.0, 20)
X, Y = np.meshgrid(x, y)

# Compute the media influence field
U, V = media_influence_field(X, Y)

# Labels and title
xlabel = "Media Reach (units)"
ylabel = "Audience Engagement (%)"
title = "Media Influence Distribution"

annotation_text = "Peak Influence"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(8, 7))
ax.quiver(X, Y, U, V, color="navy", scale=50, width=0.003)

# Set labels and title
ax.set_xlabel(xlabel, fontsize=13)
ax.set_ylabel(ylabel, fontsize=13)
ax.set_title(title, fontsize=16, fontweight="bold")

# Set background color and grid
ax.set_facecolor("lightyellow")
ax.grid(True, linestyle="--", alpha=0.7, color="gray")

# Additional Annotations
ax.annotate(
    annotation_text,
    xy=(60, 60),
    xytext=(70, 70),
    arrowprops=dict(facecolor="black", shrink=0.05),
    fontsize=10,
    color="maroon",
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plot
plt.tight_layout()
plt.savefig("quiver_54.pdf", bbox_inches="tight")
