
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Define the ocean current field function for a geographic region
def ocean_current_field(X, Y):
    # Simulated dynamic ocean current field
    U = np.cos(np.pi * X / 90) * np.sin(np.pi * Y / 90)
    V = np.sin(np.pi * X / 90) * np.cos(np.pi * Y / 90)
    return U, V

# Create a grid of points
x = np.linspace(-180.0, 180.0, 30)
y = np.linspace(-90.0, 90.0, 30)
X, Y = np.meshgrid(x, y)

# Compute the ocean current vectors
U, V = ocean_current_field(X, Y)
xlabel = "Longitude (degrees)"
ylabel = "Latitude (degrees)"
title = "Ocean Current Distribution Over a Region"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(8, 7))
ax.quiver(X, Y, U, V, color="mediumseagreen", scale=30, width=0.004)

# Set labels and title
ax.set_xlabel(xlabel, fontsize=14)
ax.set_ylabel(ylabel, fontsize=14)
ax.set_title(title, fontsize=16, fontweight="bold")

# Set background color and grid
ax.set_facecolor("lightyellow")  # Light yellow background
ax.grid(True, linestyle="--", alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plot
plt.tight_layout()
plt.savefig("quiver_55.pdf", bbox_inches="tight")
