
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

def wind_flow_vector_field(X, Y):
    # Simulate wind flow over a terrain
    U = -Y * 0.3 + np.random.normal(0, 0.5, X.shape)
    V = X * 0.3 + np.random.normal(0, 0.5, Y.shape)
    return U, V

# Create a grid of geographical points
x = np.linspace(-50.0, 50.0, 20)
y = np.linspace(-50.0, 50.0, 20)
X, Y = np.meshgrid(x, y)

# Compute the vector field
U, V = wind_flow_vector_field(X, Y)
xlabel = "Longitude"
ylabel = "Latitude"
title = "Wind Flow: Over a Terrain"
annotation_text = "Wind Center"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(7, 6))
quiver = ax.quiver(
    X, Y, U, V, color="teal", angles="xy", scale_units="xy", scale=0.6
)

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Grid and aspect ratio
ax.grid(True, linestyle="--", alpha=0.5)
ax.set_aspect("equal")

# Add annotations
ax.annotate(
    annotation_text,
    xy=(0, 0),
    xytext=(-30, 30),
    arrowprops=dict(color="coral", shrink=0.05),
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plot
plt.tight_layout()
plt.savefig("quiver_58.pdf", bbox_inches="tight")
