
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

def viral_content_vector_field(X, Y):
    # Simulate the spread of viral content from the center
    U = np.sin(X) * 0.5
    V = np.cos(Y) * 0.5
    return U, V

# Create a grid of points
x = np.linspace(-25.0, 25.0, 20)
y = np.linspace(-25.0, 25.0, 20)
X, Y = np.meshgrid(x, y)

# Compute the vector field
U, V = viral_content_vector_field(X, Y)
xlabel = "Virtual Space (Units)"
ylabel = "Engagement Intensity"
title = "Viral Content Spread on Social Media"
annotation_text = "Origin of Viral Content"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(7, 6))
quiver = ax.quiver(
    X, Y, U, V, color="saddlebrown", angles="xy", scale_units="xy", scale=0.1
)

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Grid and aspect ratio
ax.grid(True, linestyle="--", alpha=0.5)
ax.set_aspect("equal")

# Add annotations
ax.annotate(
    annotation_text,
    xy=(0, 0),
    xytext=(10, 10),
    arrowprops=dict(color="darkgreen", shrink=0.05),
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plot
plt.tight_layout()
plt.savefig("quiver_59.pdf", bbox_inches="tight")
