

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)


def disease_spread(X, Y):
    # Simulating disease spread pattern as affected by wind vectors
    U = -Y * np.sin(np.pi / 12) + X * np.cos(np.pi / 12)
    V = X * np.sin(np.pi / 12) + Y * np.cos(np.pi / 12)
    return U, V


# Create a grid of points representing geographical region
x = np.linspace(0, 200, 15)
y = np.linspace(0, 200, 15)
X, Y = np.meshgrid(x, y)

# Compute the vector field for disease spread
U, V = disease_spread(X, Y)
magnitude = np.sqrt(U**2 + V**2)

xlabel = "Longitude (km)"
ylabel = "Latitude (km)"
title = "Simulated Spread of Airborne Disease"
cbar_label = "Spread Intensity (units)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(8, 6))
quiver = ax.quiver(X, Y, U, V, magnitude, cmap="viridis", scale=5)

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Show grid
ax.grid(True, linestyle="--", alpha=0.5)

# Add color bar to show magnitude
cbar = plt.colorbar(quiver, ax=ax)
cbar.set_label(cbar_label)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plot
plt.tight_layout()
plt.savefig("quiver_61.pdf", bbox_inches="tight")
