

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Define the vector field function for performance changes
def performance_vector_field(X, Y):
    U = np.sin(2 * np.pi * X / 100) * np.cos(2 * np.pi * Y / 100)
    V = -np.cos(2 * np.pi * X / 100) * np.sin(2 * np.pi * Y / 100)
    return U, V

# Create a grid of points representing scores
x = np.linspace(0, 100, 20)
y = np.linspace(0, 100, 20)
X, Y = np.meshgrid(x, y)

# Compute the vector field for performance changes
U, V = performance_vector_field(X, Y)
speed = np.sqrt(U**2 + V**2)

# Text labels
xlabel = "Math Scores"
ylabel = "Science Scores"
title = "Performance Changes Across Subjects"
cbar_label = "Rate of Change in Performance"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(8, 6))
Q = ax.quiver(X, Y, U, V, speed, cmap="viridis", alpha=0.9)

# Set labels and title
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_title(title, fontsize=14)

# Show grid
ax.grid(True, linestyle="--", alpha=0.6)

# Add a color bar
cbar = fig.colorbar(Q, ax=ax)
cbar.set_label(cbar_label, fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plot
plt.tight_layout()
plt.savefig("quiver_65.pdf", bbox_inches="tight")

