

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Define the vector field function for wind patterns
def wind_pattern_field(X, Y):
    # Simulate wind flow over a region
    U = np.sin(np.pi * Y / 10) * np.exp(-X**2 / 100)
    V = np.cos(np.pi * X / 10) * np.exp(-Y**2 / 100)
    return U, V

# Create a grid of points
x = np.linspace(-20.0, 20.0, 50)
y = np.linspace(-20.0, 20.0, 50)
X, Y = np.meshgrid(x, y)

# Compute the wind pattern field
U, V = wind_pattern_field(X, Y)
xlabel = "Longitude"
ylabel = "Latitude"
title = "Wind Patterns Over a Region"
colorbar_title = "Wind Speed (m/s)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(7, 6))

# Use an oceanic color scheme
colors = np.sqrt(U**2 + V**2)
quiver = ax.quiver(X, Y, U, V, colors, cmap="ocean")

# Add a color bar to show the wind speed
cbar = fig.colorbar(quiver, ax=ax)
cbar.set_label(colorbar_title)

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Show grid
ax.grid(True, linestyle="--", alpha=0.7)

# Adjust the aspect ratio
ax.set_aspect("equal")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()

# Display the plot
plt.savefig("quiver_66.pdf", bbox_inches="tight")

