

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Define the vector field function for traffic flow
def traffic_flow(X, Y):
    # Hypothetical influences from major roads and intersections
    U = np.sin(2 * np.pi * (Y + X) / 30)
    V = np.cos(2 * np.pi * (Y - X) / 30)
    return U, V

# Create a fine grid of points for the traffic flow field
x = np.linspace(-20.0, 20.0, 50)
y = np.linspace(-20.0, 20.0, 50)
X, Y = np.meshgrid(x, y)

# Compute the flow vectors
U, V = traffic_flow(X, Y)

xlabel = "X Coordinate (km)"
ylabel = "Y Coordinate (km)"
title = "Hypothetical Traffic Flow in an Urban Area"
colorbar_title = "Flow Intensity"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(8, 7))

# Use a more contrasting and informative color scheme
colors = np.sqrt(U**2 + V**2)
quiver = ax.quiver(X, Y, U, V, colors, cmap="YlOrRd", pivot='mid', scale=10, headwidth=3)

# Add a color bar to show the flow intensity
cbar = fig.colorbar(quiver, ax=ax)
cbar.set_label(colorbar_title)

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Show grid
ax.grid(True, linestyle="--", alpha=0.7)

# Adjust the aspect ratio
ax.set_aspect("equal")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()

# Display the plot
plt.savefig("quiver_67.pdf", bbox_inches="tight")

