

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Set a seed for reproducibility
np.random.seed(0)

# Define the vector field function for wind patterns
def wind_pattern(X, Y):
    # Simulate wind patterns with a periodic pattern
    U = np.sin(2 * np.pi * X / 20) + np.cos(2 * np.pi * Y / 20)
    V = -np.cos(2 * np.pi * X / 20) + np.sin(2 * np.pi * Y / 20)
    return U, V

# Create a finer grid of points for wind patterns
x = np.linspace(0.0, 100.0, 50)
y = np.linspace(0.0, 100.0, 50)
X, Y = np.meshgrid(x, y)

# Compute the wind patterns
U, V = wind_pattern(X, Y)
xlabel = "Longitude (degrees)"
ylabel = "Latitude (degrees)"
title = "Wind Pattern Velocities"
colorbar_title = "Wind Speed (m/s)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(8, 6))

# Use a more contrasting color scheme
colors = np.sqrt(U**2 + V**2)
quiver = ax.quiver(X, Y, U, V, colors, cmap="viridis")

# Add a color bar to show the wind speed
cbar = fig.colorbar(quiver, ax=ax)
cbar.set_label(colorbar_title)

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Show grid
ax.grid(True, linestyle="--", alpha=0.7)

# Adjust the aspect ratio
ax.set_aspect("equal")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()

# Display the plot
plt.savefig("quiver_68.pdf", bbox_inches="tight")

