
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Define a vector field function that represents ocean currents changes
def vector_field(X, Y):
    # Example function to mimic ocean currents affected by climate change
    U = np.sin(X) * np.cos(Y)
    V = -np.cos(X) * np.sin(Y)
    return U, V

# Create a grid of points
x = np.linspace(-5.0, 5.0, 20)
y = np.linspace(-5.0, 5.0, 20)
X, Y = np.meshgrid(x, y)

# Compute the vector field
U, V = vector_field(X, Y)
xlabel = "Longitude"
ylabel = "Latitude"
title = "Climate Change Impact on Ocean Currents"
colorbar_title = "Current Magnitude"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(10, 8))

# Use colors to represent the intensity of the changes
colors = np.sqrt(U**2 + V**2)
quiver = ax.quiver(X, Y, U, V, colors, cmap="coolwarm")

# Add the color bar
cbar = fig.colorbar(quiver, ax=ax)
cbar.set_label(colorbar_title)

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Show grid
ax.grid(True, linestyle="--", alpha=0.7)

# Adjust the aspect ratio to be equal for correct representation
ax.set_aspect("equal")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing
plt.tight_layout()

# Save and display the plot
plt.savefig("quiver_70.pdf", bbox_inches="tight")
