

# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(2)

# Define the vector field function for population flow
def population_vector_field(X, Y):
    # Hypothetical function representing population flow in a geographical area
    U = 2 * np.cos(Y / 10)
    V = 2 * np.sin(X / 10)
    return U, V

# Create a finer grid of points (representing different geographical locations)
x = np.linspace(-100.0, 100.0, 30)
y = np.linspace(-100.0, 100.0, 30)
X, Y = np.meshgrid(x, y)

# Compute the vector field
U, V = population_vector_field(X, Y)
xlabel = "Geographical X Coordinate"
ylabel = "Geographical Y Coordinate"
title = "Population Flow Distribution in the Area"
cbar_label = "Population Flow Intensity"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(10, 8))

# Use a more population-themed color scheme
colors = np.sqrt(U**2 + V**2)
quiver = ax.quiver(X, Y, U, V, colors, cmap='RdYlGn_r')

# Add several streamlines to the vector field plot for better visualization
strm = ax.streamplot(X, Y, U, V, color='darkred', linewidth=1)

# Set labels and title
ax.set_xlabel(xlabel, fontsize=14)
ax.set_ylabel(ylabel, fontsize=14)
ax.set_title(title, fontsize=16, pad=20)

# Show grid
ax.grid(True, linestyle="--", alpha=0.5)

# Add color bar
cbar = plt.colorbar(quiver, ax=ax)
cbar.set_label(cbar_label, rotation=270, labelpad=20)

# Adjust the aspect ratio
ax.set_aspect("equal")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()

# Display the plot
plt.savefig("quiver_73.pdf", bbox_inches="tight")
