

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(79)

def viewer_engagement(X, Y):
    # Simulating viewer engagement based on time of day and current viewers
    U = 0.4 * np.sin(np.pi * X / 24)  # cyclic function for time of day
    V = -0.001 * (Y - 500)            # viewer engagement variation
    return U, V

# Create a grid of points for time (hours) and viewers
x = np.linspace(0, 24, 10)     # Hours in a day
y = np.linspace(0, 1000, 10)   # Number of viewers
X, Y = np.meshgrid(x, y)

# Compute the viewer engagement vector field
U, V = viewer_engagement(X, Y)
magnitude = np.sqrt(U**2 + V**2)

xlabel = "Time of Day (Hours)"
ylabel = "Number of Viewers"
title = "Viewer Engagement Vector Field"
colorbar_title = "Engagement Magnitude"
suptitle = "Vector Field Indicating Viewer Engagement Patterns"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(10, 8))
quiver = ax.quiver(X, Y, U, V, magnitude, cmap="coolwarm", scale=5, pivot='mid')

# Set labels and title
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_title(title, fontsize=14)
fig.suptitle(suptitle, fontsize=16, y=1.02)

# Show grid
ax.grid(True, linestyle="--", alpha=0.7)

# Add color bar to show magnitude
cbar = plt.colorbar(quiver, ax=ax)
cbar.set_label(colorbar_title, fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plot
plt.tight_layout()
plt.savefig("quiver_79.pdf", bbox_inches="tight")

