
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

def population_flow_field(X, Y):
    # Simulating population flow in a city
    U = np.sin(X / 2) * np.cos(Y / 2)
    V = np.cos(X / 2) * np.sin(Y / 2)
    return U, V

# Create a grid of points representing the city landscape
x = np.linspace(0.0, 10.0, 15)
y = np.linspace(0.0, 10.0, 15)
X, Y = np.meshgrid(x, y)

# Compute the population flow vector field
U, V = population_flow_field(X, Y)
magnitude = np.sqrt(U**2 + V**2)

xlabel = "Longitude (degrees)"
ylabel = "Latitude (degrees)"
title = "Population Distribution and Flow in the City"
colorbar_title = "Population Flow Magnitude (people/s)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(10, 8))
quiver = ax.quiver(X, Y, U, V, magnitude, cmap="viridis", scale=15)

# Set labels and title
ax.set_xlabel(xlabel, fontsize=14)
ax.set_ylabel(ylabel, fontsize=14)
ax.set_title(title, fontsize=16, weight='bold')

# Show grid with enhanced style
ax.grid(True, linestyle="--", alpha=0.7, color='grey')

# Add color bar to show magnitude
cbar = plt.colorbar(quiver, ax=ax)
cbar.set_label(colorbar_title, fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plot
plt.tight_layout()
plt.savefig("quiver_80.pdf", bbox_inches="tight")
