
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Data
categories = [
    "Python",
    "JavaScript",
    "Java",
    "C#",
    "C++",
    "PHP",
    "Swift",
    "Go",
    "Rust",
]
values1 = [80, 90, 80, 70, 75, 65, 60, 55, 50]
values2 = [90, 80, 70, 65, 60, 75, 80, 55, 65]
yticks = [20, 40, 60, 80, 100]
ylim = [0, 100]
xlabel = "Programming Languages Comparison"
legendlabels = ["Popularity", "Ease of Use"]
title = "Comparison of Programming Languages"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Size of the figure
fig, ax = plt.subplots(figsize=(8, 7), subplot_kw=dict(polar=True))

# Number of variables
num_vars = len(categories)
# Compute angle for each category
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()

# The plot is circular, so we need to "complete the loop" and append the start to the end.
values1 += values1[:1]
values2 += values2[:1]
angles += angles[:1]

margin = 0.1  # Adjust margin for labels
# Draw one axe per variable and add labels with a margin
labels = []
for angle, label in zip(angles[:-1], categories):
    x_offset = margin * np.cos(angle)
    y_offset = margin * np.sin(angle)
    labels.append(
        ax.text(
            angle + x_offset,
            120 + y_offset,
            label,
            color="black",
            size=10,
            horizontalalignment="center",
            verticalalignment="center",
        )
    )
plt.xticks(angles[:-1], [])

# Draw ylabels
ax.set_rlabel_position(0)
plt.yticks(yticks, [], color="#bceced", size=7)
plt.ylim(ylim)

# Plot data
ax.plot(
    angles,
    values2,
    linewidth=1.5,
    linestyle="solid",
    label=legendlabels[1],
    color="#FF7F0E",
    marker="o",
)
ax.fill(angles, values2, "#FF7F0E", alpha=0.25)

ax.plot(
    angles,
    values1,
    linewidth=1.5,
    linestyle="solid",
    label=legendlabels[0],
    color="#1F77B4",
    marker="o",
)
ax.fill(angles, values1, "#1F77B4", alpha=0.25)

# Add data labels
for angle, value in zip(angles, values1):
    ax.text(
        angle,
        value,
        str(value),
        color="black",
        size=10,
        horizontalalignment="center",
        verticalalignment="bottom",
    )
for angle, value in zip(angles, values2):
    ax.text(
        angle,
        value,
        str(value),
        color="black",
        size=10,
        horizontalalignment="center",
        verticalalignment="bottom",
    )

# Add legend
plt.legend(
    loc="lower center",
    ncol=2,
    bbox_to_anchor=(0.5, -0.2),
)

# Add titles
plt.title(title, size=14, color="black", x=0.5, y=1.15)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("radar_22.pdf", bbox_inches="tight")
