

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from math import pi

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Define the data for each characteristic
values1 = [85, 90, 80, 75, 70, 60, 95]  # Participant A
values2 = [70, 75, 80, 85, 90, 65, 60]  # Participant B
values3 = [60, 70, 75, 80, 85, 95, 70]  # Participant C
xlabels = ["Empathy", "Emotional Intelligence", "Mindfulness", "Resilience", "Stress Management", "Self-Esteem", "Cognitive Flexibility"]
yticks = [20, 40, 60, 80]
title = "Psychological Metrics of Participants"
labels = ["Participant A", "Participant B", "Participant C"]
ylim = [0, 100]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Initialize the spider plot
fig, ax = plt.subplots(figsize=(8, 7), subplot_kw=dict(polar=True))

# Number of variables
num_vars = len(values1)

# Compute angle for each axis
angles = [n / float(num_vars) * 2 * pi for n in range(num_vars)]
angles += angles[:1]  # Complete the loop

# Repeat the first value to close the circle
values1 += values1[:1]
values2 += values2[:1]
values3 += values3[:1]

# Define colors
color1 = "#3288bd"
color2 = "#99d594"
color3 = "#e6f598"
gridline_color = "#bce2bc"

# Draw one axe per variable and add labels
plt.xticks(
    angles[:-1],
    xlabels,
    size=10,
)

# Draw ylabels
ax.set_rlabel_position(0)
plt.yticks(yticks, [], color="#7f9c7b", size=7)
plt.ylim(ylim)

# Draw the inner circles with green color lines
for circle in ax.get_ygridlines():
    circle.set_color(gridline_color)

# Plot each technology
ax.plot(angles, values1, linewidth=2, linestyle="-.", marker='o', label=labels[0], color=color1)
ax.fill(angles, values1, color1, alpha=0.1)

ax.plot(angles, values2, linewidth=2, linestyle="--", marker='s', label=labels[1], color=color2)
ax.fill(angles, values2, color2, alpha=0.1)

ax.plot(angles, values3, linewidth=2, linestyle=":", marker='^', label=labels[2], color=color3)
ax.fill(angles, values3, color3, alpha=0.1)

# Add data labels
for i in range(num_vars):
    plt.text(
        angles[i],
        values1[i],
        str(values1[i]),
        horizontalalignment="center",
        size=8,
        color="black",
    )
    plt.text(
        angles[i],
        values2[i],
        str(values2[i]),
        horizontalalignment="center",
        size=8,
        color="black",
    )
    plt.text(
        angles[i],
        values3[i],
        str(values3[i]),
        horizontalalignment="center",
        size=8,
        color="black",
    )

# Add a legend and title
plt.legend(loc="lower center", bbox_to_anchor=(0.5, -0.1), ncol=3)
plt.title(title, position=(0.5, -0.15), ha="center")

# Adjust figure size to match original image's dimensions
fig.set_size_inches(8, 7)
ax.spines["polar"].set_color(gridline_color)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("radar_25.pdf", bbox_inches="tight")

