
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from math import pi

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Define the data for each fitness regime
values1 = [8, 6, 7, 5, 8, 9, 7]  # Strength Training
values2 = [6, 9, 6, 8, 7, 5, 6]  # Cardio Training
values3 = [5, 6, 9, 4, 6, 8, 7]  # Yoga Training
xlabels = [
    "Strength",
    "Endurance",
    "Flexibility",
    "Speed",
    "Agility",
    "Balance",
    "Coordination",
]
yticks = [2, 4, 6, 8, 10]
title = "Physical Fitness Metrics Comparison"
labels = ["Strength Training", "Cardio Training", "Yoga Training"]
ylim = [0, 10]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Initialize the spider plot
fig, ax = plt.subplots(figsize=(8, 7), subplot_kw=dict(polar=True))

# Number of variables
num_vars = len(values1)

# Compute angle for each axis
angles = [n / float(num_vars) * 2 * pi for n in range(num_vars)]
angles += angles[:1]  # Complete the loop

# Repeat the first value to close the circle
values1 += values1[:1]
values2 += values2[:1]
values3 += values3[:1]

# Draw one axe per variable and add labels
plt.xticks(
    angles[:-1],
    xlabels,
    size=10,
)

# Draw ylabels
ax.set_rlabel_position(0)
plt.yticks(yticks, [], color="#d4af37", size=7)
plt.ylim(ylim)

# Draw the inner circles with gold color lines
for circle in ax.get_ygridlines():
    circle.set_color("#d4af37")

# Plot each fitness regime with different styles
ax.plot(
    angles, values1, linewidth=2, linestyle="solid", label=labels[0], color="#cc5500"
)
ax.fill(angles, values1, "#cc5500", alpha=0.1)

ax.plot(
    angles, values2, linewidth=2, linestyle="dashed", label=labels[1], color="#0033a0"
)
ax.fill(angles, values2, "#0033a0", alpha=0.1)

ax.plot(
    angles, values3, linewidth=2, linestyle="dashdot", label=labels[2], color="#228b22"
)
ax.fill(angles, values3, "#228b22", alpha=0.1)

# Add data labels
for i in range(num_vars):
    plt.text(
        angles[i],
        values1[i],
        str(values1[i]),
        horizontalalignment="center",
        size=8,
        color="black",
    )
    plt.text(
        angles[i],
        values2[i],
        str(values2[i]),
        horizontalalignment="center",
        size=8,
        color="black",
    )
    plt.text(
        angles[i],
        values3[i],
        str(values3[i]),
        horizontalalignment="center",
        size=8,
        color="black",
    )

# Add a legend and title
plt.legend(loc="lower center", bbox_to_anchor=(0.5, -0.1), ncol=3)
plt.title(title, position=(0.5, -0.1), ha="center")

# Adjust figure size to match original image's dimensions
fig.set_size_inches(8, 7)
ax.spines["polar"].set_color("#d4af37")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("radar_26.pdf", bbox_inches="tight")
